/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.statistics;

import gr.forth.ics.vrp.corevrp.Output;
import gr.forth.ics.vrp.corevrp.model.Model;
import gr.forth.ics.vrp.corevrp.model.RDF_Class;
import gr.forth.ics.vrp.corevrp.model.RDF_DAG;
import gr.forth.ics.vrp.corevrp.model.RDF_MetaClass;
import gr.forth.ics.vrp.corevrp.model.RDF_Property;
import gr.forth.ics.vrp.corevrp.model.RDF_Resource;
import gr.forth.ics.vrp.corevrp.model.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RDFModelStatistics {
    private Model mdl = null;
    private HashMap dag = null;

    public RDFModelStatistics(Model model) {
        this.mdl = model;
    }

    public HashMap instancesPerClass() {
        Collection collection = this.mdl.getClasses();
        Collection collection2 = this.mdl.getDataResources();
        Iterator iterator = collection.iterator();
        HashMap<Resource, Integer> hashMap = new HashMap<Resource, Integer>();
        Resource resource = this.mdl.getResource("http://www.w3.org/2000/01/rdf-schema#Resource");
        while (iterator.hasNext()) {
            hashMap.put((RDF_Class)iterator.next(), new Integer(0));
        }
        Iterator iterator2 = collection2.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object e = iterator2.next();
            if (e instanceof RDF_Resource) {
                object = (RDF_Resource)e;
                ArrayList arrayList = ((RDF_Resource)object).gettype();
                Iterator iterator3 = arrayList.iterator();
                while (iterator3.hasNext()) {
                    RDF_Class rDF_Class = (RDF_Class)iterator3.next();
                    Integer n = (Integer)hashMap.get(rDF_Class);
                    hashMap.put(rDF_Class, new Integer(n + 1));
                }
                continue;
            }
            if (resource != null) {
                object = (Integer)hashMap.get(resource);
                hashMap.put(resource, new Integer((Integer)object + 1));
                continue;
            }
            resource = new RDF_Class("http://www.w3.org/2000/01/rdf-schema#Resource");
            hashMap.put(resource, new Integer(1));
        }
        return hashMap;
    }

    public HashMap getInstanceDistribution() {
        HashMap hashMap = this.instancesPerClass();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Integer n2 = (Integer)hashMap2.get(n);
            if (n2 == null) {
                hashMap2.put(n, new Integer(1));
                continue;
            }
            hashMap2.put(n, new Integer(n2 + 1));
        }
        return hashMap2;
    }

    public void printInstanceDistribution() {
        HashMap hashMap = this.getInstanceDistribution();
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        Collection collection = hashMap.values();
        Iterator iterator2 = collection.iterator();
        Output output = new Output();
        output.out("\nInstance Distribution\n", true);
        output.out("-------------------------\n", true);
        output.out("Instances/Class  Number of Classes\n", true);
        while (iterator.hasNext() && iterator2.hasNext()) {
            output.out(((Integer)iterator.next()).toString() + "\t\t" + ((Integer)iterator2.next()).toString() + "\n", true);
        }
    }

    private void schemaPropertyHierarchyStatistics(HashSet hashSet) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        ArrayList arrayList = new ArrayList();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            RDF_Property rDF_Property = (RDF_Property)iterator.next();
            this.traverseHierarchy(rDF_Property, 0, rDF_Property.getID(), nArray, arrayList);
        }
        this.formatHierarchyStatistics(nArray, "Hierarchy: SchemaProperty (a dump class that is considered root of all schema properties) ");
    }

    private void computePartDistribution(RDF_DAG rDF_DAG, String string, int n) {
        RDF_Class rDF_Class;
        Object object;
        RDF_Class rDF_Class2 = new RDF_Class(string);
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = rDF_DAG.getroots();
        HashSet hashSet2 = (HashSet)hashSet.clone();
        int n2 = 0;
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object = (RDF_Class)iterator.next();
            if (n == 0) {
                if (object instanceof RDF_MetaClass) continue;
                ++n2;
                rDF_DAG.enter((Resource)object, rDF_Class2);
                continue;
            }
            if (n == 1) {
                if (!(object instanceof RDF_MetaClass) || ((RDF_MetaClass)(rDF_Class = (RDF_MetaClass)object)).getKind() != 0) continue;
                ++n2;
                rDF_DAG.enter((Resource)object, rDF_Class2);
                continue;
            }
            if (n != 2 || !(object instanceof RDF_MetaClass) || ((RDF_MetaClass)(rDF_Class = (RDF_MetaClass)object)).getKind() != 1) continue;
            ++n2;
            rDF_DAG.enter((Resource)object, rDF_Class2);
        }
        if (n2 != 0) {
            this.traverseHierarchy(rDF_Class2, 0, rDF_Class2.getID(), nArray, arrayList);
            this.formatHierarchyStatistics(nArray, "Hierarchy: " + rDF_Class2.getID());
            this.relativeDistribution(rDF_DAG, 0, 0, rDF_Class2);
            this.relativeDistribution(rDF_DAG, 0, 1, rDF_Class2);
            object = hashSet2.iterator();
            while (object.hasNext()) {
                RDF_Class rDF_Class3;
                rDF_Class = (RDF_Class)object.next();
                if (n == 0) {
                    if (rDF_Class instanceof RDF_MetaClass) continue;
                    rDF_DAG.remove(rDF_Class, rDF_Class2);
                    continue;
                }
                if (n == 1) {
                    if (!(rDF_Class instanceof RDF_MetaClass) || ((RDF_MetaClass)(rDF_Class3 = rDF_Class)).getKind() != 0) continue;
                    rDF_DAG.remove(rDF_Class, rDF_Class2);
                    continue;
                }
                if (n != 2 || !(rDF_Class instanceof RDF_MetaClass) || ((RDF_MetaClass)(rDF_Class3 = (RDF_MetaClass)rDF_Class)).getKind() != 1) continue;
                rDF_DAG.remove(rDF_Class, rDF_Class2);
            }
            rDF_DAG.remove(rDF_Class2);
            rDF_DAG.findRoots();
        }
    }

    public void printHierarchyStatistics(RDF_DAG rDF_DAG, boolean bl) {
        Output output = new Output();
        HashSet hashSet = rDF_DAG.getroots();
        this.dag = rDF_DAG.getdag();
        if (this.dag.size() > 0) {
            if (bl) {
                int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
                ArrayList arrayList = new ArrayList();
                Resource resource = this.mdl.getResource("http://www.w3.org/2000/01/rdf-schema#Class");
                if (resource != null && resource instanceof RDF_Class) {
                    RDF_Class rDF_Class = (RDF_Class)resource;
                    this.traverseHierarchy(rDF_Class, 0, rDF_Class.getID(), nArray, arrayList);
                    this.formatHierarchyStatistics(nArray, "Hierarchy: " + rDF_Class.getID());
                    this.relativeDistribution(rDF_DAG, 0, 0, rDF_Class);
                    this.relativeDistribution(rDF_DAG, 0, 1, rDF_Class);
                } else {
                    this.computePartDistribution(rDF_DAG, "http://www.w3.org/2000/01/rdf-schema#Class", 1);
                }
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = 0;
                    ++n;
                }
                arrayList = new ArrayList();
                resource = this.mdl.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
                if (resource != null && resource instanceof RDF_Class) {
                    RDF_Class rDF_Class = (RDF_Class)resource;
                    this.traverseHierarchy(rDF_Class, 0, rDF_Class.getID(), nArray, arrayList);
                    this.formatHierarchyStatistics(nArray, "Hierarchy: " + rDF_Class.getID());
                    this.relativeDistribution(rDF_DAG, 0, 0, rDF_Class);
                    this.relativeDistribution(rDF_DAG, 0, 1, rDF_Class);
                } else {
                    this.computePartDistribution(rDF_DAG, "http://www.w3.org/1999/02/22-rdf-syntax-ns#Property", 2);
                }
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = 0;
                    ++n2;
                }
                arrayList = new ArrayList();
                resource = this.mdl.getResource("http://www.w3.org/2000/01/rdf-schema#Resource");
                if (resource != null && resource instanceof RDF_Class) {
                    RDF_Class rDF_Class = (RDF_Class)resource;
                    this.traverseHierarchy(rDF_Class, 0, rDF_Class.getID(), nArray, arrayList);
                    this.formatHierarchyStatistics(nArray, "Hierarchy: " + rDF_Class.getID());
                    this.relativeDistribution(rDF_DAG, 0, 0, rDF_Class);
                    this.relativeDistribution(rDF_DAG, 0, 1, rDF_Class);
                } else {
                    this.computePartDistribution(rDF_DAG, "http://www.w3.org/2000/01/rdf-schema#Resource", 0);
                }
            } else {
                this.schemaPropertyHierarchyStatistics(hashSet);
                this.relativeDistribution(rDF_DAG, 1, 0, null);
                this.relativeDistribution(rDF_DAG, 1, 1, null);
            }
        }
    }

    private void formatHierarchyStatistics(int[] nArray, String string) {
        Output output = new Output();
        output.outln(string, true);
        output.outln("\tNumber of hierarchy nodes: " + nArray[2], true);
        if (nArray[2] > 1) {
            output.outln("\tMaximum number of subnodes: " + nArray[0], true);
            double d = 0.0;
            if (nArray[2] != 0) {
                d = (double)nArray[1] / (double)nArray[2];
            }
            output.outln("\tAverage number of subnodes: " + d, true);
            output.outln("\tMaximum Depth: " + nArray[3], true);
            double d2 = 0.0;
            if (nArray[5] != 0) {
                d2 = (double)nArray[4] / (double)nArray[5];
            }
            output.outln("\tAverage Depth: " + d2, true);
            output.outln("\tNumber of paths: " + nArray[5], true);
            double d3 = 0.0;
            if (nArray[2] != 0) {
                d3 = (double)nArray[7] / (double)nArray[2];
            }
            output.outln("\tMaximum number of supernodes: " + nArray[6], true);
            output.outln("\tAverage number of supernodes: " + d3, true);
            double d4 = 0.0;
            if (nArray[2] != 0) {
                d4 = (double)nArray[8] / (double)nArray[2];
            }
            output.outln("\tNodes percentage having more than one supernode: " + d4, true);
        }
    }

    private void traverseHierarchy(Object object, int n, String string, int[] nArray, ArrayList arrayList) {
        ArrayList arrayList2 = (ArrayList)this.dag.get(object);
        if (arrayList2 == null) {
            return;
        }
        HashSet hashSet = (HashSet)arrayList2.get(0);
        HashSet hashSet2 = (HashSet)arrayList2.get(1);
        int n2 = hashSet.size();
        int n3 = hashSet2.size();
        if (!arrayList.contains(object)) {
            arrayList.add(object);
            if (nArray[0] < n2) {
                nArray[0] = n2;
            }
            nArray[1] = nArray[1] + n2;
            nArray[2] = nArray[2] + 1;
            if (nArray[6] < n3) {
                nArray[6] = n3;
            }
            nArray[7] = nArray[7] + n3;
            if (n3 > 1) {
                nArray[8] = nArray[8] + 1;
            }
        }
        if (nArray[3] < n) {
            nArray[3] = n;
        }
        nArray[4] = nArray[4] + n;
        nArray[5] = nArray[5] + n2;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.traverseHierarchy(e, n + 1, string.concat(((Resource)e).getID()), nArray, arrayList);
        }
    }

    public void relativeDistribution(RDF_DAG rDF_DAG, int n, int n2, Resource resource) {
        Object object;
        Object object2;
        Object object3;
        Iterator<Object> iterator;
        Collection<Object> collection;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        if (n == 0) {
            rDF_DAG.getAllDescendants(resource);
            rDF_DAG.getAllAncestors();
        } else {
            collection = rDF_DAG.getroots();
            iterator = ((HashSet)collection).iterator();
            while (iterator.hasNext()) {
                object3 = (RDF_Property)iterator.next();
                rDF_DAG.getAllDescendants((Resource)object3);
            }
            rDF_DAG.getAllAncestors();
        }
        collection = this.dag.values();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object3 = (ArrayList)iterator.next();
            object2 = null;
            object2 = n2 == 0 ? (Integer)((ArrayList)object3).get(2) : (Integer)((ArrayList)object3).get(3);
            object = (Integer)hashMap.get(object2);
            if (object == null) {
                hashMap.put(object2, new Integer(1));
                continue;
            }
            hashMap.put(object2, new Integer((Integer)object + 1));
        }
        object3 = hashMap.keySet();
        object2 = object3.iterator();
        object = new Output();
        if (n2 == 0) {
            ((Output)object).out("Number of descendants", true);
        } else {
            ((Output)object).out("Number of ancestors", true);
        }
        if (n == 0) {
            ((Output)object).out("   Number of Classes\n", true);
        } else {
            ((Output)object).out("   Number of Properties\n", true);
        }
        while (object2.hasNext()) {
            Integer n3 = (Integer)object2.next();
            ((Output)object).out(n3.toString() + "\t\t" + ((Integer)hashMap.get(n3)).toString() + "\n", true);
        }
    }
}

