/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.corevrp.validator;

import gr.forth.ics.vrp.corevrp.Main;
import gr.forth.ics.vrp.corevrp.Output;
import gr.forth.ics.vrp.corevrp.RDF_Error;
import gr.forth.ics.vrp.corevrp.model.Model;
import gr.forth.ics.vrp.corevrp.model.RDF_Class;
import gr.forth.ics.vrp.corevrp.model.RDF_Container;
import gr.forth.ics.vrp.corevrp.model.RDF_DAG;
import gr.forth.ics.vrp.corevrp.model.RDF_Property;
import gr.forth.ics.vrp.corevrp.model.RDF_Resource;
import gr.forth.ics.vrp.corevrp.model.RDF_Statement;
import gr.forth.ics.vrp.corevrp.model.Resource;
import gr.forth.ics.vrp.corevrp.vocabulary.rdf;
import gr.forth.ics.vrp.corevrp.vocabulary.rdfschema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class RDF_Validator {
    public Model basis_model;
    private RDF_DAG class_dag;
    private RDF_DAG property_dag;
    private RDF_Error e = new RDF_Error();
    private boolean verbose = false;
    private boolean graph = false;
    private boolean classLoop = false;
    private boolean propertyLoop = false;
    private boolean inheritance = false;
    private boolean subsetSubpropertyDomainRange = false;
    private boolean uniqueDefinedDomainRange = false;
    private boolean typing = false;
    private boolean sourceTargetTypes = false;
    private Output out = new Output();
    private long inheritTime = 0L;

    public RDF_Validator(Model model) {
        this.basis_model = model;
    }

    public void setverbose(boolean bl) {
        this.verbose = bl;
    }

    public void setgraph(boolean bl) {
        this.graph = bl;
    }

    public void setclassLoop(boolean bl) {
        this.classLoop = bl;
    }

    public void setpropertyLoop(boolean bl) {
        this.propertyLoop = bl;
    }

    public void setinheritance(boolean bl) {
        this.inheritance = bl;
    }

    public void setsubsetSubpropertyDomainRange(boolean bl) {
        this.subsetSubpropertyDomainRange = bl;
    }

    public void setuniqueDefinedDomainRange(boolean bl) {
        this.uniqueDefinedDomainRange = bl;
    }

    public void settyping(boolean bl) {
        this.typing = bl;
    }

    public void setsourceTargetTypes(boolean bl) {
        this.sourceTargetTypes = bl;
    }

    public RDF_DAG getsubClassOfDAG() {
        return this.class_dag;
    }

    public void setsubClassOfDAG(RDF_DAG rDF_DAG) {
        this.class_dag = rDF_DAG;
    }

    public RDF_DAG getsubPropertyOfDAG() {
        return this.property_dag;
    }

    public void setsubPropertyOfDAG(RDF_DAG rDF_DAG) {
        this.property_dag = rDF_DAG;
    }

    public long getinheritTime() {
        return this.inheritTime;
    }

    public boolean validate() {
        boolean bl = false;
        RDF_Error rDF_Error = new RDF_Error();
        String string = "RDF_Validator.validate";
        if (this.subsetSubpropertyDomainRange && !this.propertyLoop) {
            rDF_Error.emit_warning("The constraint 'Property Hierarchy Loops' will also be checked. Verification of the constraint 'Domain/Range of SubProperties' can be done as long as there is no loop in the subproperty hierarchy", string);
            this.propertyLoop = true;
        }
        if (this.inheritance && !this.propertyLoop) {
            rDF_Error.emit_warning("The constraint 'Property Hierarchy Loops' will also be checked. Inference on Domain/Range can be done as long as there is no loop in the subproperty hierarchy", string);
            this.propertyLoop = true;
        }
        boolean bl2 = false;
        if (this.propertyLoop) {
            bl2 = this.subProperty_check();
        }
        if (this.inheritance) {
            if (bl2) {
                long l = System.currentTimeMillis();
                this.inheritDomainRange();
                long l2 = System.currentTimeMillis();
                this.inheritTime = l2 - l;
            } else {
                rDF_Error.emit_warning("Inheritance of domain/range cannot performed since there are loops in the property hierarchy", string);
            }
        }
        if (this.subsetSubpropertyDomainRange) {
            if (bl2) {
                this.subpropertyDomainRange_check();
            } else {
                rDF_Error.emit_warning("Domain/Range of subProperties is not checked  since there are loops in the property hierarchy", string);
            }
        }
        if (this.sourceTargetTypes) {
            this.domain_range_check();
        }
        if (this.typing) {
            this.type_check();
        }
        if (this.classLoop) {
            this.subClassOf_check();
        }
        if (this.verbose) {
            this.out.outln("finished validation", false);
        }
        if (Main.error_counter == 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isRangeUnique(RDF_Property rDF_Property) {
        boolean bl = false;
        if (rDF_Property.getrange().size() == 1) {
            bl = true;
        }
        return bl;
    }

    private boolean isRangeMultiDefined(RDF_Property rDF_Property) {
        boolean bl = false;
        if (rDF_Property.getrange().size() > 1) {
            this.e.emit_error(3, 30, rDF_Property.getID(), "RDF_Validator.isRangeMultiDefined");
            bl = true;
        }
        return bl;
    }

    private boolean type_check() {
        if (this.verbose) {
            System.out.println("Checking the types and statements ...");
        }
        boolean bl = true;
        Collection collection = this.basis_model.getNodes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDF_Resource rDF_Resource;
            Object e = iterator.next();
            if (e instanceof RDF_Statement) {
                rDF_Resource = (RDF_Statement)e;
                if (!((RDF_Statement)rDF_Resource).valid()) {
                    this.e.emit_error(3, 34, rDF_Resource.getID(), "RDF_Validator.type_check");
                    bl = false;
                }
                if (!rDF_Resource.has_type((RDF_Class)this.basis_model.existing.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement"))) {
                    this.e.emit_error(3, 35, rDF_Resource.getID(), "RDF_Validator.type_check");
                    bl = false;
                }
            }
            if (!(!(e instanceof RDF_Class) || rdf.Classes.contains((rDF_Resource = (RDF_Class)e).getID()) || rdfschema.Classes.contains(rDF_Resource.getID()) || rDF_Resource.getID().startsWith("http://www.w3.org/2001/XMLSchema#") || ((RDF_Class)rDF_Resource).has_type((RDF_Class)this.basis_model.existing.get("http://www.w3.org/2000/01/rdf-schema#Class")))) {
                this.e.emit_error(3, 36, rDF_Resource.getID(), "RDF_Validator.type_check");
                bl = false;
            }
            if (e instanceof RDF_Property && !rdf.Properties.contains((rDF_Resource = (RDF_Property)e).getID()) && !rdfschema.Properties.contains(rDF_Resource.getID())) {
                if (rDF_Resource.getID().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) {
                    String string = rDF_Resource.getID();
                    int n = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_".length();
                    string = string.substring(n);
                    try {
                        Integer n2 = new Integer(string);
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        this.e.emit_error(3, 37, rDF_Resource.getID(), "RDF_Validator.type_check");
                    }
                } else if (!rDF_Resource.has_type((RDF_Class)this.basis_model.existing.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"))) {
                    this.e.emit_error(3, 37, rDF_Resource.getID(), "RDF_Validator.type_check");
                    bl = false;
                }
            }
            if (!(e instanceof RDF_Container) || (rDF_Resource = (RDF_Container)e).has_type((RDF_Class)this.basis_model.existing.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag")) && !rDF_Resource.has_type((RDF_Class)this.basis_model.existing.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq")) && !rDF_Resource.has_type((RDF_Class)this.basis_model.existing.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt"))) continue;
            this.e.emit_error(3, 38, rDF_Resource.getID(), "RDF_Validator.type_check");
            bl = false;
        }
        return bl;
    }

    private boolean subProperty_check() {
        if (this.verbose) {
            this.out.outln("Checking for loops in properties ...", false);
        }
        this.create_property_dag();
        boolean bl = this.property_dag.loopcheck();
        if (!bl) {
            Iterator iterator = this.property_dag.getloop_element().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = e instanceof Resource ? ((Resource)e).getID() : e.toString();
                this.e.emit_error(3, 29, string, "Validator.subProperty_check");
            }
        }
        if (this.verbose && bl) {
            this.out.outln("no loops found in Property definitions", false);
        }
        if (this.verbose && bl) {
            this.out.outln("The topological order of subPropertyOf (top down): ", true);
            this.out.outln(this.property_dag.output(), true);
        }
        return bl;
    }

    public boolean subClassOf_check() {
        if (this.verbose) {
            this.out.outln("Checking for loops in classes ...", false);
        }
        this.create_class_dag();
        boolean bl = this.class_dag.loopcheck();
        if (!bl) {
            Iterator iterator = this.class_dag.getloop_element().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = e instanceof Resource ? ((Resource)e).getID() : e.toString();
                this.e.emit_error(3, 29, string, "Validator.subClassOf_check");
            }
        }
        if (this.verbose && bl) {
            this.out.outln("no loops found in Class definitions", false);
        }
        if (this.verbose) {
            this.out.out("The topological order of subClassOf (top down): ", true);
            this.out.outln(this.class_dag.output(), true);
        }
        return bl;
    }

    private void inheritDomainRange() {
        ArrayList arrayList = this.property_dag.getorder();
        int n = 0;
        while (n < arrayList.size()) {
            Object e;
            RDF_Property rDF_Property;
            boolean bl = true;
            boolean bl2 = true;
            if ((rDF_Property = (e = arrayList.get(n++)) instanceof Resource ? (RDF_Property)e : (RDF_Property)this.basis_model.getResource(e.toString())).getsubPropertyOf().size() <= 0) continue;
            if (rDF_Property.getsubPropertyOf().size() > 1 && rDF_Property.getrange().isEmpty()) {
                this.e.emit_warning("Because of property " + rDF_Property.getID() + " of having multiple subproperties, inheritance of range is not performed.", "RDF_Validator.inheritDomainRange");
                bl = false;
            }
            if (rDF_Property.getsubPropertyOf().size() > 1 && rDF_Property.getdomain().isEmpty()) {
                this.e.emit_warning("Because of property " + rDF_Property.getID() + " of having multiple subproperties, inheritance of domain is not performed.", "RDF_Validator.inheritDomainRange");
                bl2 = false;
            }
            ArrayList arrayList2 = rDF_Property.getsubPropertyOf();
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                RDF_Property rDF_Property2;
                if (!(rDF_Property2 = (RDF_Property)arrayList2.get(n2++)).getrange().isEmpty() && bl && rDF_Property.getrange().isEmpty()) {
                    rDF_Property.setrange(rDF_Property2.getrange());
                }
                if (rDF_Property2.getdomain().size() <= 0 || !bl2 || rDF_Property.getdomain().size() != 0) continue;
                rDF_Property.setdomain(rDF_Property2.getdomain());
            }
        }
    }

    public void subpropertyDomainRange_check() {
        ArrayList arrayList = this.property_dag.getorder();
        int n = 0;
        while (n < arrayList.size()) {
            Object e;
            RDF_Property rDF_Property = (e = arrayList.get(n++)) instanceof Resource ? (RDF_Property)e : (RDF_Property)this.basis_model.getResource(e.toString());
            ArrayList arrayList2 = rDF_Property.getsubPropertyOf();
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                Object object;
                Object object2;
                RDF_Property rDF_Property2;
                if (!(rDF_Property2 = (RDF_Property)arrayList2.get(n2++)).getrange().isEmpty()) {
                    object2 = (RDF_Class)rDF_Property2.getrange().get(0);
                    if (rDF_Property.getrange().isEmpty()) {
                        this.e.emit_error(3, 39, rDF_Property.getID() + " and the super property " + rDF_Property2.getID(), "RDF_Validator.sPO_range_domain");
                    } else {
                        object = (RDF_Class)rDF_Property.getrange().get(0);
                        if (!(object == object2 || this.compare_classes(((Resource)object).getID(), ((Resource)object2).getID()) || ((Resource)object).getID().equals("http://www.w3.org/2000/01/rdf-schema#Literal") && ((Resource)object2).getID().equals("http://www.w3.org/2001/XMLSchema#string") || ((Resource)object).getID().equals("http://www.w3.org/2001/XMLSchema#string") && ((Resource)object2).getID().equals("http://www.w3.org/2000/01/rdf-schema#Literal"))) {
                            this.e.emit_error(3, 39, rDF_Property.getID() + " and the super property " + rDF_Property2.getID(), "RDF_Validator.sPO_range_domain");
                        }
                    }
                }
                if (rDF_Property2.getdomain().size() <= 0) continue;
                if (rDF_Property.getdomain().size() == 0 && !rDF_Property2.getdomain().contains((RDF_Class)this.basis_model.existing.get("http://www.w3.org/2000/01/rdf-schema#Resource"))) {
                    this.e.emit_error(3, 40, rDF_Property.getID() + " and the super property " + rDF_Property2.getID(), "RDF_Validator.sPO_range_domain");
                    continue;
                }
                object2 = rDF_Property.getdomain();
                object = rDF_Property2.getdomain();
                int n3 = 0;
                while (n3 < ((ArrayList)object2).size()) {
                    RDF_Class rDF_Class = (RDF_Class)((ArrayList)object2).get(n3++);
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < ((ArrayList)object).size()) {
                        RDF_Class rDF_Class2 = (RDF_Class)((ArrayList)object).get(n4++);
                        bl = this.compare_classes(rDF_Class.getID(), rDF_Class2.getID());
                        if (bl) break;
                    }
                    if (bl) continue;
                    this.e.emit_error(3, 40, rDF_Property.getID() + " and the super property " + rDF_Property2.getID(), "RDF_Validator.sPO_range_domain");
                }
            }
        }
    }

    private boolean compare_classes(String string, String string2) {
        boolean bl = false;
        if (string.equals(string2)) {
            return true;
        }
        RDF_Class rDF_Class = (RDF_Class)this.basis_model.getResource(string);
        if (rDF_Class.containssubClassOf_type(string2)) {
            return true;
        }
        ArrayList arrayList = rDF_Class.getsubClassOf();
        int n = 0;
        while (n < arrayList.size()) {
            RDF_Class rDF_Class2 = (RDF_Class)arrayList.get(n++);
            bl = this.compare_classes(rDF_Class2.getID(), string2);
        }
        return bl;
    }

    private void domain_range_check() {
        if (this.verbose) {
            System.out.println("Checking for domain and range ...");
        }
        Collection collection = this.basis_model.getNodes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_Property)) continue;
            RDF_Property rDF_Property = (RDF_Property)e;
            try {
                rDF_Property.range_domain_check();
            }
            catch (Exception exception) {
                RDF_Error rDF_Error = new RDF_Error();
                rDF_Error.emit_error(3, 41, "" + exception.getMessage(), "validator.domain_range_check");
            }
        }
    }

    public void create_class_dag() {
        this.class_dag = new RDF_DAG();
        Iterator iterator = this.basis_model.getClasses().iterator();
        while (iterator.hasNext()) {
            RDF_Class rDF_Class = (RDF_Class)iterator.next();
            ArrayList arrayList = rDF_Class.getsubClassOf();
            this.class_dag.enter(rDF_Class);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                RDF_Class rDF_Class2 = (RDF_Class)iterator2.next();
                this.class_dag.enter(rDF_Class, rDF_Class2);
            }
        }
        this.class_dag.output();
    }

    public void create_property_dag() {
        this.property_dag = new RDF_DAG();
        Iterator iterator = this.basis_model.getProperties().iterator();
        while (iterator.hasNext()) {
            RDF_Property rDF_Property = (RDF_Property)iterator.next();
            ArrayList arrayList = rDF_Property.getsubPropertyOf();
            this.property_dag.enter(rDF_Property);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                RDF_Property rDF_Property2 = (RDF_Property)iterator2.next();
                this.property_dag.enter(rDF_Property, rDF_Property2);
            }
        }
    }
}

