/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.corevrp.model;

import gr.forth.ics.vrp.corevrp.model.Existing;
import gr.forth.ics.vrp.corevrp.model.Link;
import gr.forth.ics.vrp.corevrp.model.Literal;
import gr.forth.ics.vrp.corevrp.model.RDF_Class;
import gr.forth.ics.vrp.corevrp.model.RDF_Resource;
import gr.forth.ics.vrp.corevrp.model.Resource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class RDF_Property
extends RDF_Resource {
    private ArrayList subPropertyOf = new ArrayList(2);
    private ArrayList range = new ArrayList(1);
    private ArrayList domain = new ArrayList(1);
    private ArrayList link_list = new ArrayList();

    RDF_Property() {
    }

    RDF_Property(URL uRL) {
        this.setID(uRL.toString());
    }

    RDF_Property(String string) {
        this.setID(string);
    }

    public RDF_Property(Resource resource) {
        this.setID(resource.getID());
    }

    public RDF_Property(RDF_Resource rDF_Resource) {
        this.setID(rDF_Resource.getID());
        this.setcomment(rDF_Resource.getcomment());
        this.setlabel(rDF_Resource.getlabel());
        this.setseeAlso(rDF_Resource.getseeAlso());
        this.setisDefinedBy(rDF_Resource.getisDefinedBy());
        this.setvalue(rDF_Resource.getvalue());
        this.settype(rDF_Resource.gettype());
    }

    public void addsubPropertyOf(RDF_Property rDF_Property) {
        if (!this.subPropertyOf.contains(rDF_Property)) {
            this.subPropertyOf.add(rDF_Property);
        }
    }

    public ArrayList getsubPropertyOf() {
        return this.subPropertyOf;
    }

    public void addrange(RDF_Class rDF_Class) {
        if (!this.range.contains(rDF_Class)) {
            this.range.add(rDF_Class);
        }
    }

    public ArrayList getrange() {
        return this.range;
    }

    public void adddomain(RDF_Class rDF_Class) {
        if (!this.domain.contains(rDF_Class)) {
            this.domain.add(rDF_Class);
        }
    }

    public void setrange(ArrayList arrayList) {
        this.range = arrayList;
    }

    public void setsubPropertyOf(ArrayList arrayList) {
        this.subPropertyOf = arrayList;
    }

    public ArrayList getdomain() {
        return this.domain;
    }

    public void setdomain(ArrayList arrayList) {
        this.domain = arrayList;
    }

    public void addlink(int n, int n2) {
        if (!this.link_contains(n, n2)) {
            Link link = new Link(n, n2);
            this.link_list.add(link);
        }
    }

    void addlink(int n, Literal literal) {
        if (!this.link_contains(n, literal)) {
            Link link = new Link(n, literal);
            this.link_list.add(link);
        }
    }

    boolean link_contains(int n, int n2) {
        int n3 = 0;
        while (n3 < this.link_list.size()) {
            Integer n4;
            Link link;
            Object object;
            if ((object = (link = (Link)this.link_list.get(n3++)).getobject()) instanceof Literal) {
                return false;
            }
            int n5 = link.getsubject_int();
            if (n5 != n || (n4 = (Integer)object) != n2) continue;
            return true;
        }
        return false;
    }

    boolean link_contains(int n, Literal literal) {
        int n2 = 0;
        while (n2 < this.link_list.size()) {
            Link link;
            Object object;
            if (!((object = (link = (Link)this.link_list.get(n2++)).getobject()) instanceof Literal)) {
                return false;
            }
            Literal literal2 = (Literal)object;
            int n3 = link.getsubject_int();
            if (n3 != n || !literal2.equals(literal)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getlink() {
        return this.link_list;
    }

    public void solve_links(Existing existing) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Iterator iterator = this.link_list.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            link.solve_links(existing);
            arrayList.add(link);
        }
        this.link_list = arrayList;
    }

    public boolean range_domain_check() throws Exception {
        Iterator iterator = this.link_list.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            try {
                link.domain_range_check(this.getdomain(), this.getrange());
            }
            catch (Exception exception) {
                throw new Exception(exception.getMessage() + " used with " + this.getID());
            }
        }
        return true;
    }
}

