/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.corevrp.model;

import gr.forth.ics.vrp.corevrp.Output;
import gr.forth.ics.vrp.corevrp.RDF_Error;
import gr.forth.ics.vrp.corevrp.model.Existing;
import gr.forth.ics.vrp.corevrp.model.IModel;
import gr.forth.ics.vrp.corevrp.model.Link;
import gr.forth.ics.vrp.corevrp.model.Literal;
import gr.forth.ics.vrp.corevrp.model.Namespace;
import gr.forth.ics.vrp.corevrp.model.RDF_Class;
import gr.forth.ics.vrp.corevrp.model.RDF_Container;
import gr.forth.ics.vrp.corevrp.model.RDF_MetaClass;
import gr.forth.ics.vrp.corevrp.model.RDF_Property;
import gr.forth.ics.vrp.corevrp.model.RDF_Resource;
import gr.forth.ics.vrp.corevrp.model.RDF_Statement;
import gr.forth.ics.vrp.corevrp.model.Resource;
import gr.forth.ics.vrp.corevrp.model.Triple;
import gr.forth.ics.vrp.corevrp.parser.parser;
import gr.forth.ics.vrp.corevrp.vocabulary.rdf;
import gr.forth.ics.vrp.corevrp.vocabulary.rdfschema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Model
extends Resource
implements IModel {
    public Existing existing = null;
    private int anonymos = 1;
    private String BaseURI = "";
    private RDF_Error e = new RDF_Error();
    private HashMap model_list = new HashMap();
    private ArrayList done_list = new ArrayList();
    private HashMap namespaces = new HashMap();
    private boolean verbose = false;
    private boolean getandadd = false;
    private String myrdfschemans = "http://139.91.183.30:9090/RDF/VRP/Examples/22-rdf-syntax-ns.rdf";
    private String myrdfschemaXML = "<?xml version=\"1.0\"?><!DOCTYPE rdf:RDF [   <!ENTITY rdf \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">     <!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\">]>  <!-- Universal RDF Schema namespace written by Karsten Tolle, 05.12.2002. --><rdf:RDF   xmlns:rdf=\"&rdf;\"   xmlns:rdfs=\"&rdfs;\"><rdfs:Class rdf:about=\"&rdfs;Resource\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">Resource</rdfs:label>  <rdfs:comment>The class resource, everything.</rdfs:comment></rdfs:Class><rdf:Property rdf:about=\"&rdf;type\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">type</rdfs:label>  <rdfs:comment>Indicates membership of a class</rdfs:comment>  <rdfs:range rdf:resource=\"&rdfs;Class\"/>  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/></rdf:Property><rdfs:Class rdf:about=\"&rdfs;Class\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">Class</rdfs:label>  <rdfs:comment>The concept of Class</rdfs:comment>  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/></rdfs:Class><rdf:Property rdf:about=\"&rdfs;subClassOf\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">subClassOf</rdfs:label>  <rdfs:comment>Indicates membership of a class</rdfs:comment>  <rdfs:range rdf:resource=\"&rdfs;Class\"/>  <rdfs:domain rdf:resource=\"&rdfs;Class\"/></rdf:Property><rdf:Property rdf:about=\"&rdfs;subPropertyOf\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">subPropertyOf</rdfs:label>  <rdfs:comment>Indicates specialization of properties</rdfs:comment>  <rdfs:range rdf:resource=\"&rdf;Property\"/>  <rdfs:domain rdf:resource=\"&rdf;Property\"/></rdf:Property><rdfs:Class rdf:about=\"&rdf;Property\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">Property</rdfs:label>  <rdfs:comment>The concept of a property.</rdfs:comment>  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/></rdfs:Class><rdf:Property rdf:about=\"&rdfs;comment\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">comment</rdfs:label>  <rdfs:comment>Use this for descriptions</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/>  <rdfs:range rdf:resource=\"&rdfs;Literal\"/></rdf:Property><rdf:Property rdf:about=\"&rdfs;label\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">label</rdfs:label>  <rdfs:comment>Provides a human-readable version of a resource name.</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/>  <rdfs:range rdf:resource=\"&rdfs;Literal\"/></rdf:Property><rdf:Property rdf:about=\"&rdfs;domain\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">domain</rdfs:label>  <rdfs:comment>A domain class for a property type</rdfs:comment> <rdfs:range rdf:resource=\"&rdfs;Class\"/>  <rdfs:domain rdf:resource=\"&rdf;Property\"/></rdf:Property><rdf:Property rdf:about=\"&rdfs;range\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">range</rdfs:label>  <rdfs:comment>A range class for a property type</rdfs:comment>  <rdfs:range rdf:resource=\"&rdfs;Class\"/>  <rdfs:domain rdf:resource=\"&rdf;Property\"/></rdf:Property><rdf:Property rdf:about=\"&rdfs;seeAlso\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">seeAlso</rdfs:label>  <rdfs:comment>A resource that provides information about the subject resource</rdfs:comment>  <rdfs:range rdf:resource=\"&rdfs;Resource\"/>  <rdfs:domain   rdf:resource=\"&rdfs;Resource\"/></rdf:Property><rdf:Property rdf:about=\"&rdfs;isDefinedBy\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdf:type resource=\"&rdf;Property\"/>  <rdfs:subPropertyOf rdf:resource=\"&rdfs;seeAlso\"/>  <rdfs:label xml:lang=\"en\">isDefinedBy</rdfs:label>  <rdfs:comment>Indicates the namespace of a resource</rdfs:comment>  <rdfs:range rdf:resource=\"&rdfs;Resource\"/>  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/></rdf:Property><rdfs:Class rdf:about=\"&rdfs;Literal\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">Literal</rdfs:label>  <rdfs:comment>This represents the set of atomic values, eg. textual strings.</rdfs:comment></rdfs:Class><rdfs:Class rdf:about=\"&rdf;Statement\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">Statement</rdfs:label>  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/>  <rdfs:comment>The class of RDF statements.</rdfs:comment></rdfs:Class><rdf:Property about=\"&rdf;subject\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">subject</rdfs:label>  <rdfs:comment>The subject of an RDF statement.</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdf;Statement\"/>  <rdfs:range rdf:resource=\"&rdfs;Resource\"/></rdf:Property><rdf:Property about=\"&rdf;predicate\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">predicate</rdfs:label>  <rdfs:comment>the predicate of an RDF statement.</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdf;Statement\"/>  <rdfs:range rdf:resource=\"&rdf;Property\"/></rdf:Property><rdf:Property about=\"&rdf;object\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">object</rdfs:label>  <rdfs:comment>The object of an RDF statement.</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdf;Statement\"/></rdf:Property><rdfs:Class rdf:about=\"&rdfs;Container\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">Container</rdfs:label>  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/>  <rdfs:comment>This represents the set Containers.</rdfs:comment></rdfs:Class><rdfs:Class rdf:about=\"&rdf;Bag\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">Bag</rdfs:label>  <rdfs:comment xml:lang=\"en\">An unordered collection.</rdfs:comment>  <rdfs:subClassOf rdf:resource=\"&rdfs;Container\"/></rdfs:Class><rdfs:Class rdf:about=\"&rdf;Seq\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">Seq</rdfs:label>  <rdfs:comment xml:lang=\"en\">An ordered collection.</rdfs:comment>  <rdfs:subClassOf rdf:resource=\"&rdfs;Container\"/></rdfs:Class><rdfs:Class rdf:about=\"&rdf;Alt\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">Alt</rdfs:label>  <rdfs:comment xml:lang=\"en\">A collection of alternatives.</rdfs:comment>  <rdfs:subClassOf rdf:resource=\"&rdfs;Container\"/></rdfs:Class><rdfs:Class rdf:about=\"&rdfs;ContainerMembershipProperty\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">ContainerMembershipProperty</rdfs:label>  <rdfs:comment>The container membership properties, rdf:1, rdf:2, ..., all of which are sub-properties of 'member'.</rdfs:comment>  <rdfs:subClassOf rdf:resource=\"&rdf;Property\"/></rdfs:Class><rdf:Property rdf:about=\"&rdfs;member\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">member</rdfs:label>  <rdfs:comment>a member of a container</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdfs;Container\"/></rdf:Property><rdf:Property rdf:about=\"&rdf;value\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">value</rdfs:label>  <rdfs:comment>Identifies the principal value (usually a string) of a property when the property value is a structured resource</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/></rdf:Property><!-- the following are new additions, Nov 2002 --><rdfs:Class rdf:about=\"&rdf;List\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">List</rdfs:label>  <rdfs:comment xml:lang=\"en\">The class of RDF Lists</rdfs:comment></rdfs:Class><rdf:List rdf:about=\"&rdf;nil\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">nil</rdfs:label>  <rdfs:comment xml:lang=\"en\">The empty list, with no items in it. If the rest of a list is nil then the list has no more items in it.</rdfs:comment></rdf:List><rdf:Property rdf:about=\"&rdf;first\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">first</rdfs:label>  <rdfs:comment xml:lang=\"en\">The first item in an RDF list. Also often called the head.</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdf;List\"/></rdf:Property><rdf:Property rdf:about=\"&rdf;rest\">  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>  <rdfs:label xml:lang=\"en\">rest</rdfs:label>  <rdfs:comment xml:lang=\"en\">The rest of an RDF list after the first item. Also often called the tail.</rdfs:comment>  <rdfs:domain rdf:resource=\"&rdf;List\"/>  <rdfs:range rdf:resource=\"&rdf;List\"/></rdf:Property><rdfs:Class rdf:about=\"&rdfs;Datatype\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">Datatype</rdfs:label>  <rdfs:comment xml:lang=\"en\">The class of datatypes.</rdfs:comment></rdfs:Class>\t<rdfs:Class rdf:about=\"&rdfs;XMLLiteral\">  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>  <rdfs:label xml:lang=\"en\">XMLLiteral</rdfs:label>  <rdfs:comment>The class of XML literals.</rdfs:comment></rdfs:Class><rdf:Description rdf:about=\"&rdfs;\">  <rdfs:seeAlso rdf:resource=\"http://www.w3.org/2000/01/rdf-schema-more\"/></rdf:Description></rdf:RDF>";
    private String myrdfns = "http://139.91.183.30:9090/RDF/VRP/Examples/rdf-schema.rdf";
    private String myrdfXML = "<?xml version=\"1.0\"?><!DOCTYPE rdf:RDF [   <!ENTITY rdf \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">     <!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\">]>  <rdf:RDF   xml:base=\"http://139.91.183.30:9090/RDF/VRP/Examples/22-rdf-syntax-ns.rdf\"  xmlns=\"&rdf;\"  xmlns:rdf=\"&rdf;\"  xmlns:rdfs=\"&rdfs;\"><!--Universal RDF namespace written by Karsten Tolle, 30.04.2002.--><!--This is the RDF Schema for the RDF data model as described in the  Resource Description Framework (RDF) Model and Syntax Specification  http://www.w3.org/TR/REC-rdf-syntax--><rdfs:Class rdf:about=\"&rdf;Statement\"  rdfs:comment=\"A triple consisting of a predicate, a subject, and an object.\" /><rdfs:Class rdf:about=\"&rdf;Property\"  rdfs:comment=\"A name of a property, defining specific meaning for the property\" /><rdfs:Class rdf:about=\"&rdf;Bag\"  rdfs:comment=\"An unordered collection\" /><rdfs:Class rdf:about=\"&rdf;Seq\"  rdfs:comment=\"An ordered collection\" /><rdfs:Class rdf:about=\"&rdf;Alt\"  rdfs:comment=\"A collection of alternatives\" /><rdf:Property rdf:about=\"&rdf;predicate\"  rdfs:comment=\"Identifies the property used in a statement when representing the statement in reified form\">  <rdfs:domain rdf:resource=\"&rdf;Statement\" />  <rdfs:range rdf:resource=\"&rdf;Property\" /></rdf:Property><rdf:Property rdf:about=\"&rdf;subject\"  rdfs:comment=\"Identifies the resource that a statement is describing when representing the statement in reified form\">  <rdfs:domain rdf:resource=\"&rdf;Statement\" /></rdf:Property><rdf:Property rdf:about=\"&rdf;object\"  rdfs:comment=\"Identifies the object of a statement when representing the statement in reified form\" /><rdf:Property rdf:about=\"&rdf;type\"  rdfs:comment=\"Identifies the Class of a resource\" /><rdf:Property rdf:about=\"&rdf;value\"  rdfs:comment=\"Identifies the principal value (usually a string) of a property when the property value is a structured resource\" /><rdfs:Class rdf:about=\"&rdf;List\"  rdfs:comment=\"The class of RDF Lists\" /><rdf:List rdf:about=\"&rdf;nil\"  rdfs:comment=\"The empty list, with no items in it. If the rest of a list is nil then the list has no more items in it.\" /><rdf:Property rdf:about=\"&rdf;first\"  rdfs:comment=\"The first item in an RDF list. Also often called the head.\" /><rdf:Property rdf:about=\"&rdf;rest\"  rdfs:comment=\"The rest of an RDF list after the first item. Also often called the tail.\" /></rdf:RDF>";

    public void setverbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getverbose() {
        return this.verbose;
    }

    public Model(boolean bl) {
        this.existing = new Existing(bl);
    }

    public void setNamespaces(HashMap hashMap) {
        this.namespaces = hashMap;
    }

    public void addStatement(String string, String string2, Object object) {
        Object object2;
        int n;
        Object object3;
        String string3;
        Literal literal = null;
        boolean bl = true;
        if (object instanceof Literal) {
            bl = false;
            literal = (Literal)object;
            string3 = literal.toString();
        } else {
            string3 = object.toString();
        }
        int n2 = 0;
        String string4 = "Tripel: " + string + ", " + string2 + ", " + string3;
        this.RDF_test(string2);
        if (bl) {
            this.RDF_test(string3);
        }
        int n3 = this.enter_Property(string);
        if (string.startsWith("http://www.w3.org/2000/01/rdf-schema#") || string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            this.RDF_Property_test(string);
        }
        if ((object3 = this.existing.get(string2)) == null) {
            object3 = new Resource(string2);
            n = this.existing.put(string2, object3);
        } else {
            n = this.existing.get_int(string2);
        }
        if (bl) {
            Object object4 = this.existing.get(string3);
            if (object4 == null) {
                object4 = new Resource(string3);
                n2 = this.existing.put(string3, object4);
            } else {
                n2 = this.existing.get_int(string3);
            }
            if (string.startsWith("http://www.w3.org/2000/01/rdf-schema#")) {
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#subClassOf")) {
                    this.enter_subClassOf(object3, object4, string2, string3);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#subPropertyOf")) {
                    this.enter_subPropertyOf(object3, object4, string2, string3);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#range")) {
                    this.enter_domain_range(2, object3, object4, string2, string3);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#domain")) {
                    this.enter_domain_range(1, object3, object4, string2, string3);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#seeAlso")) {
                    this.enter_sA_iDB_C_L_V(1, object3, string2, literal, n2);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#isDefinedBy")) {
                    this.enter_sA_iDB_C_L_V(2, object3, string2, literal, n2);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#comment") || string.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                    this.e.emit_error(3, 19, string4, "Model.addStatement");
                }
            }
            if (string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                    this.enter_type(object3, string2, string3);
                }
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject")) {
                    this.enter_s_p_o(1, object3, object4, string2, string3);
                }
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate")) {
                    this.enter_s_p_o(2, object3, object4, string2, string3);
                }
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#object")) {
                    this.enter_s_p_o(3, object3, object4, string2, string3);
                }
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#value")) {
                    this.enter_sA_iDB_C_L_V(5, object3, string2, literal, n2);
                }
                if (string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) {
                    this.enter_msp(object3, string2, new Integer(n2));
                }
            }
        } else {
            if (string.startsWith("http://www.w3.org/2000/01/rdf-schema#")) {
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#subClassOf") || string.equals("http://www.w3.org/2000/01/rdf-schema#subPropertyOf") || string.equals("http://www.w3.org/2000/01/rdf-schema#range") || string.equals("http://www.w3.org/2000/01/rdf-schema#domain")) {
                    this.e.emit_error(3, 20, string4, "Model.addStatement");
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#comment")) {
                    this.enter_sA_iDB_C_L_V(3, object3, string2, literal, -1);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                    this.enter_sA_iDB_C_L_V(4, object3, string2, literal, -1);
                }
                if (string.equals("http://www.w3.org/2000/01/rdf-schema#seeAlso") || string.equals("http://www.w3.org/2000/01/rdf-schema#isDefinedBy")) {
                    this.e.emit_error(3, 20, string4, "Model.addStatement");
                }
            }
            if (string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") || string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject") || string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate")) {
                    this.e.emit_error(3, 20, string4, "Model.addStatement");
                }
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#object")) {
                    this.enter_s_p_o(3, object3, literal, string2, string3);
                }
                if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#value")) {
                    this.enter_sA_iDB_C_L_V(5, object3, string2, literal, -1);
                }
                if (string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) {
                    this.enter_msp(object3, string2, literal);
                }
            }
        }
        if (!string.startsWith("http://www.w3.org/2000/01/rdf-schema#") && !string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && (object2 = this.existing.get(string)) != null) {
            if (object2 instanceof RDF_Property) {
                RDF_Property rDF_Property = (RDF_Property)object2;
                if (bl) {
                    rDF_Property.addlink(n, n2);
                } else {
                    rDF_Property.addlink(n, literal);
                }
            } else {
                this.e.emit_error(3, 23, string4, "Model.addStatement");
            }
        }
    }

    public Collection getNodes() {
        Collection collection = this.existing.values();
        return collection;
    }

    public boolean contains(String string) {
        boolean bl = this.existing.containsKey(string);
        return bl;
    }

    public Resource getResource(String string) {
        Resource resource = (Resource)this.existing.get(string);
        return resource;
    }

    public Resource getResource(int n) {
        Resource resource = (Resource)this.existing.get(n);
        return resource;
    }

    public Collection getClasses() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_Class)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Collection getAllMetaClasses() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_MetaClass)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Collection getMetaClasses() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_MetaClass) || ((RDF_MetaClass)e).getKind() != 0) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Collection getMetaProperties() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_MetaClass) || ((RDF_MetaClass)e).getKind() != 1) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Collection getProperties() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_Property)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Collection getReifiedStatements() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_Statement)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Collection getContainers() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_Container)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Collection getDataResources() {
        Collection collection = this.existing.values();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof RDF_Class || e instanceof RDF_Property || e instanceof RDF_Statement || e instanceof RDF_Container) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public boolean contains(String string, String string2, String string3) {
        RDF_Property rDF_Property;
        boolean bl = false;
        if (!this.contains(string)) {
            return false;
        }
        int n = this.existing.get_int(string2);
        int n2 = this.existing.get_int(string3);
        Resource resource = this.getResource(string);
        return resource instanceof RDF_Property && (rDF_Property = (RDF_Property)resource).link_contains(n, n2);
    }

    public boolean contains(String string, String string2, Literal literal) {
        RDF_Property rDF_Property;
        boolean bl = false;
        if (!this.contains(string)) {
            return false;
        }
        int n = this.existing.get_int(string2);
        Resource resource = this.getResource(string);
        return resource instanceof RDF_Property && (rDF_Property = (RDF_Property)resource).link_contains(n, literal);
    }

    public HashMap getNamespaces() {
        return this.namespaces;
    }

    public void fetch_all(ArrayList arrayList, parser parser2) {
        String string = this.BaseURI;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (string2.equals("")) continue;
            if (string2.endsWith("#")) {
                int n = string2.length();
                string2 = string2.substring(0, --n);
            }
            this.fetch_all_ns(string2, parser2);
        }
        this.BaseURI = string;
    }

    private void fetch_all_ns(String string, parser parser2) {
        block10: {
            String string2 = string;
            if (string.concat("#").equals("http://www.w3.org/2000/01/rdf-schema#")) {
                string = this.myrdfschemaXML;
                string2 = "http://www.w3.org/2000/01/rdf-schema#";
            }
            if (string.concat("#").equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                string = this.myrdfXML;
                string2 = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
            }
            if (string.concat("#").equals("http://www.w3.org/2001/XMLSchema#")) {
                string2 = "http://www.w3.org/2001/XMLSchema#";
                if (this.namespaces.get(string2) == null) {
                    this.namespaces.put(string2, new Namespace(string2));
                }
                return;
            }
            if (this.done_list.contains(string2)) break block10;
            this.done_list.add(string2);
            if (this.verbose) {
                System.out.println("we need to connect to: " + string);
            }
            try {
                parser parser3 = new parser(string, this);
                parser3.setonly(parser2.getonly());
                parser3.settriples(parser2.gettriples());
                parser3.setsimple(parser2.getsimple());
                parser3.setfetch_all(parser2.getfetch_all());
                parser3.setverbose(parser2.getverbose());
                parser3.setdebug(parser2.getdebug());
                parser3.parse();
                if (parser3.error_count > 0) {
                    if (!this.verbose) break block10;
                    System.err.println("error in constr: " + string);
                    break block10;
                }
                if (this.verbose) {
                    System.out.println("Namespace " + string + " added to the model");
                }
                if (!string2.endsWith("#")) {
                    string2 = string2.concat("#");
                }
                this.namespaces.put(string2, new Namespace(string2));
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    public void fetch() {
        ArrayList arrayList = new ArrayList();
        Collection collection = this.getNodes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        int n = 0;
        while (n < arrayList.size()) {
            RDF_Resource rDF_Resource;
            String string;
            Object e;
            if (!((e = arrayList.get(n++)) instanceof RDF_Property) && !(e instanceof RDF_Class) || (string = (rDF_Resource = (RDF_Resource)e).getID()).startsWith("http://www.w3.org/2000/01/rdf-schema#") || string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) continue;
            this.fetch(string);
        }
        while (!collection.containsAll(this.getNodes())) {
            this.fetch();
        }
    }

    public void fetch(String string) {
        boolean bl = true;
        if (!this.done_list.contains(string) && !string.startsWith("http://www.w3.org/2001/XMLSchema#")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            while (!arrayList.isEmpty()) {
                String string2 = arrayList.get(0).toString();
                arrayList.remove(0);
                if (string2.startsWith(this.getBaseURI())) continue;
                int n = string2.indexOf("#");
                if (n > 0) {
                    Object object;
                    Model model = null;
                    String string3 = string2.substring(0, n);
                    if (this.model_list.containsKey(string3)) {
                        model = (Model)this.model_list.get(string3);
                    } else {
                        try {
                            object = new parser(string3);
                            if (((parser)((Object)object)).error_count > 0) {
                                bl = false;
                            } else {
                                Object object2 = object.parse().value;
                                if (object2 instanceof Model) {
                                    model = (Model)object2;
                                    this.model_list.put(string3, model);
                                } else {
                                    this.e.emit_error(3, 44, "No model returned!", "Model.fetch_information");
                                }
                            }
                        }
                        catch (Exception exception) {
                            System.err.println(exception);
                        }
                    }
                    if (bl) {
                        object = model.getandadd(this, string2, string3);
                        int n2 = 0;
                        while (n2 < ((ArrayList)object).size()) {
                            String string4;
                            if (this.done_list.contains(string4 = ((ArrayList)object).get(n2++).toString()) || string4.startsWith("http://www.w3.org/2000/01/rdf-schema#") || string4.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) continue;
                            arrayList.add(string4);
                        }
                    }
                }
                this.done_list.add(string2);
            }
        }
    }

    private int enter_Property(String string) {
        int n = 0;
        Object object = this.existing.get(string);
        if (object != null) {
            if (object instanceof RDF_Class) {
                this.e.emit_error(3, 1, string, "Model.enter_Property");
            } else if (object instanceof RDF_Resource) {
                if (!(object instanceof RDF_Property)) {
                    RDF_Property rDF_Property = new RDF_Property((RDF_Resource)object);
                    n = this.existing.put(string, rDF_Property);
                }
            } else {
                RDF_Property rDF_Property = new RDF_Property(string);
                n = this.existing.put(string, rDF_Property);
            }
        } else {
            RDF_Property rDF_Property = new RDF_Property(string);
            n = this.existing.put(string, rDF_Property);
            if (string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) {
                this.addStatement("http://www.w3.org/2000/01/rdf-schema#subPropertyOf", string, "http://www.w3.org/2000/01/rdf-schema#member");
            }
        }
        return n;
    }

    private void RDF_test(String string) {
        int n;
        if (string.startsWith("http://www.w3.org/2000/01/rdf-schema#") && !rdfschema.all.contains(string)) {
            n = string.indexOf("#");
            if (string.length() <= ++n) {
                return;
            }
            this.e.emit_error(3, 25, string, "Model.RDF_test");
        }
        if (!(!string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || rdf.Classes.contains(string) || rdf.Properties.contains(string) || string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_") || string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"))) {
            n = string.indexOf("#");
            if (string.length() <= ++n) {
                return;
            }
            this.e.emit_error(3, 26, string, "Model.RDF_test");
        }
    }

    private void RDF_Property_test(String string) {
        if (string.startsWith("http://www.w3.org/2000/01/rdf-schema#") && !rdfschema.Properties.contains(string)) {
            this.e.emit_error(3, 25, string, "Model.RDF_Property_test");
        }
        if (string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && !rdf.Properties.contains(string) && !string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) {
            this.e.emit_error(3, 26, string, "Model.RDF_Property_test");
        }
    }

    private void enter_subPropertyOf(Object object, Object object2, String string, String string2) {
        RDF_Property rDF_Property;
        this.modification_extention_check("subPropertyOf", string, string2);
        RDF_Property rDF_Property2 = object2 instanceof RDF_Property ? (RDF_Property)object2 : this.make_property(string2);
        if (object instanceof RDF_Resource) {
            if (object instanceof RDF_Class) {
                this.e.emit_error(3, 1, string, "Model.enter_subPropertyOf");
            }
            if (object instanceof RDF_Statement) {
                this.e.emit_error(3, 8, string, "Model.enter_subPropertyOf");
            }
            if (object instanceof RDF_Container) {
                this.e.emit_error(3, 11, string, "Model.enter_subPropertyOf");
            }
            if (object instanceof RDF_Property) {
                rDF_Property = (RDF_Property)object;
            } else {
                rDF_Property = new RDF_Property((RDF_Resource)object);
                this.existing.put(string, rDF_Property);
            }
        } else {
            rDF_Property = new RDF_Property((Resource)object);
            this.existing.put(string, rDF_Property);
        }
        rDF_Property.addsubPropertyOf(rDF_Property2);
    }

    private void enter_subClassOf(Object object, Object object2, String string, String string2) {
        RDF_Class rDF_Class;
        this.modification_extention_check("subClassOf", string, string2);
        RDF_Class rDF_Class2 = object2 instanceof RDF_Class ? (RDF_Class)object2 : this.make_class(string2);
        if (object instanceof RDF_Resource) {
            if (object instanceof RDF_Property) {
                this.e.emit_error(3, 4, string, "Model.enter_subClassOf");
            }
            if (object instanceof RDF_Statement) {
                this.e.emit_error(3, 7, string, "Model.enter_subClassOf");
            }
            if (object instanceof RDF_Container) {
                this.e.emit_error(3, 10, string, "Model.enter_subClassOf");
            }
            if (object instanceof RDF_Class) {
                rDF_Class = (RDF_Class)object;
            } else {
                rDF_Class = new RDF_Class((RDF_Resource)object);
                this.existing.put(string, rDF_Class);
            }
        } else {
            rDF_Class = new RDF_Class((Resource)object);
            this.existing.put(string, rDF_Class);
        }
        rDF_Class.addsubClassOf(rDF_Class2);
    }

    public void infer() {
        this.infer("http://www.w3.org/2000/01/rdf-schema#Class");
        this.infer("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        this.infer("http://www.w3.org/2000/01/rdf-schema#Container");
        this.infer("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement");
        System.out.println("done");
    }

    private void infer(String string) {
        HashSet hashSet = this.get_subClassesOf((RDF_Class)this.existing.get(string));
        if (hashSet.size() <= 0) {
            return;
        }
        Collection collection = this.getNodes();
        Iterator iterator = collection.iterator();
        block0: while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDF_Resource)) continue;
            RDF_Resource rDF_Resource = (RDF_Resource)e;
            ArrayList arrayList = rDF_Resource.gettype();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                RDF_Class rDF_Class = (RDF_Class)iterator2.next();
                if (!hashSet.contains(rDF_Class)) continue;
                this.addStatement("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", rDF_Resource.getID(), string);
                continue block0;
            }
        }
    }

    private HashSet get_subClassesOf(RDF_Class rDF_Class) {
        HashSet<RDF_Class> hashSet = new HashSet<RDF_Class>();
        HashSet<RDF_Class> hashSet2 = new HashSet<RDF_Class>();
        HashSet<RDF_Class> hashSet3 = new HashSet<RDF_Class>();
        hashSet2.add(rDF_Class);
        Collection collection = this.getClasses();
        do {
            hashSet3.addAll(hashSet2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RDF_Class rDF_Class2 = (RDF_Class)iterator.next();
                ArrayList arrayList = rDF_Class2.getsubClassOf();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    RDF_Class rDF_Class3 = (RDF_Class)iterator2.next();
                    if (!hashSet2.contains(rDF_Class3)) continue;
                    hashSet.add(rDF_Class2);
                    hashSet2.add(rDF_Class2);
                }
            }
        } while (!hashSet3.containsAll(hashSet2));
        return hashSet;
    }

    private void modification_extention_check(String string, String string2, String string3) {
        if (string2.startsWith(this.BaseURI)) {
            return;
        }
        if (this.BaseURI.equals(this.myrdfschemans + "#")) {
            return;
        }
        if (this.BaseURI.equals(this.myrdfns + "#")) {
            return;
        }
        if (this.BaseURI.equals("http://www.w3.org/2000/01/rdf-schema#")) {
            return;
        }
        if (this.getandadd) {
            return;
        }
        if (string.equals("subPropertyOf") && string2.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_") && string3.equals("http://www.w3.org/2000/01/rdf-schema#member")) {
            return;
        }
        this.e.emit_warning("In the namespace " + this.BaseURI + " you want to extend or modify the resource " + string2 + " by entering a new " + string + " with the value " + string3 + ".", "Model.modification_extention_check");
    }

    private void enter_domain_range(int n, Object object, Object object2, String string, String string2) {
        RDF_Property rDF_Property;
        if (n == 1) {
            this.modification_extention_check("domain", string, string2);
        }
        if (n == 2) {
            this.modification_extention_check("range", string, string2);
        }
        RDF_Class rDF_Class = object2 instanceof RDF_Class ? (RDF_Class)object2 : this.make_class(string2);
        if (object instanceof RDF_Resource) {
            if (object instanceof RDF_Class) {
                this.e.emit_error(3, 1, string, "Model.enter_domain_range");
            }
            if (object instanceof RDF_Statement) {
                this.e.emit_error(3, 8, string, "Model.enter_domain_range");
            }
            if (object instanceof RDF_Container) {
                this.e.emit_error(3, 11, string, "Model.enter_domain_range");
            }
            if (object instanceof RDF_Property) {
                rDF_Property = (RDF_Property)object;
            } else {
                rDF_Property = new RDF_Property((RDF_Resource)object);
                this.existing.put(string, rDF_Property);
            }
        } else {
            rDF_Property = new RDF_Property((Resource)object);
            this.existing.put(string, rDF_Property);
        }
        if (n == 1) {
            rDF_Property.adddomain(rDF_Class);
        }
        if (n == 2) {
            rDF_Property.addrange(rDF_Class);
        }
    }

    private void enter_sA_iDB_C_L_V(int n, Object object, String string, Literal literal, int n2) {
        if (object instanceof RDF_Resource) {
            RDF_Resource rDF_Resource = (RDF_Resource)object;
            if (n == 1) {
                rDF_Resource.addseeAlso(n2);
            }
            if (n == 2) {
                rDF_Resource.addisDefinedBy(n2);
            }
            if (n == 3) {
                rDF_Resource.addcomment(literal);
            }
            if (n == 4) {
                rDF_Resource.addlabel(literal);
            }
            if (n == 5) {
                if (n2 > 0) {
                    rDF_Resource.addvalue(n2);
                } else {
                    rDF_Resource.addvalue(literal);
                }
            }
        } else {
            RDF_Resource rDF_Resource = new RDF_Resource((Resource)object);
            if (n == 1) {
                rDF_Resource.addseeAlso(n2);
            }
            if (n == 2) {
                rDF_Resource.addisDefinedBy(n2);
            }
            if (n == 3) {
                rDF_Resource.addcomment(literal);
            }
            if (n == 4) {
                rDF_Resource.addlabel(literal);
            }
            if (n == 5) {
                if (n2 > 0) {
                    rDF_Resource.addvalue(n2);
                } else {
                    rDF_Resource.addvalue(literal);
                }
            }
            this.existing.put(string, rDF_Resource);
        }
    }

    private void enter_s_p_o(int n, Object object, Object object2, String string, String string2) {
        RDF_Property rDF_Property = null;
        if (n == 2) {
            rDF_Property = this.make_property(string2);
        }
        if (object instanceof RDF_Resource) {
            if (object instanceof RDF_Class) {
                this.e.emit_error(3, 2, string, "Model.enter_s_p_o");
            }
            if (object instanceof RDF_Property) {
                this.e.emit_error(3, 5, string, "Model.enter_s_p_o");
            }
            if (object instanceof RDF_Container) {
                this.e.emit_error(3, 12, string, "Model.enter_s_p_o");
            }
            if (object instanceof RDF_Statement) {
                RDF_Statement rDF_Statement = (RDF_Statement)object;
                if (n == 1 && !rDF_Statement.setsubject(object2)) {
                    this.e.emit_error(3, 31, string2, "Model.enter_s_p_o");
                }
                if (n == 2 && !rDF_Statement.setpredicate(rDF_Property)) {
                    this.e.emit_error(3, 32, string2, "Model.enter_s_p_o");
                }
                if (n == 3 && !rDF_Statement.setobject(object2)) {
                    this.e.emit_error(3, 33, string2, "RDF_Statement.setobject");
                }
            } else {
                RDF_Statement rDF_Statement = new RDF_Statement((RDF_Resource)object);
                if (n == 1) {
                    rDF_Statement.setsubject(object2);
                }
                if (n == 2) {
                    rDF_Statement.setpredicate(rDF_Property);
                }
                if (n == 3) {
                    rDF_Statement.setobject(object2);
                }
                this.existing.put(string, rDF_Statement);
            }
        } else {
            RDF_Statement rDF_Statement = new RDF_Statement((Resource)object);
            if (n == 1) {
                rDF_Statement.setsubject(object2);
            }
            if (n == 2) {
                rDF_Statement.setpredicate(rDF_Property);
            }
            if (n == 3) {
                rDF_Statement.setobject(object2);
            }
            this.existing.put(string, rDF_Statement);
        }
    }

    private void enter_msp(Object object, String string, Object object2) {
        if (object instanceof RDF_Resource) {
            if (object instanceof RDF_Property) {
                this.e.emit_error(3, 6, string, "Model.enter_msp");
            }
            if (object instanceof RDF_Statement) {
                this.e.emit_error(3, 9, string, "Model.enter_msp");
            }
            if (object instanceof RDF_Class) {
                this.e.emit_error(3, 3, string, "Model.enter_msp");
            }
            if (object instanceof RDF_Container) {
                RDF_Container rDF_Container = (RDF_Container)object;
                rDF_Container.addmember(object2);
            } else {
                RDF_Container rDF_Container = new RDF_Container((RDF_Resource)object);
                rDF_Container.addmember(object2);
                this.existing.put(string, rDF_Container);
            }
        } else {
            RDF_Container rDF_Container = new RDF_Container((Resource)object);
            rDF_Container.addmember(object2);
            this.existing.put(string, rDF_Container);
        }
    }

    private void enter_type(Object object, String string, String string2) {
        RDF_Resource rDF_Resource;
        RDF_Class rDF_Class = this.make_class(string2);
        if (object instanceof RDF_Resource) {
            rDF_Resource = (RDF_Resource)object;
        } else {
            rDF_Resource = new RDF_Resource((Resource)object);
            this.existing.put(string, rDF_Resource);
        }
        rDF_Resource.addtype(rDF_Class, this.existing);
        if (string2.equals("http://www.w3.org/2000/01/rdf-schema#Class")) {
            this.make_class(string);
        }
        if (string2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property")) {
            this.make_property(string);
        }
        if (string2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement")) {
            this.make_statement(string);
        }
        if (string2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag")) {
            this.make_container(string);
        }
        if (string2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq")) {
            this.make_container(string);
        }
        if (string2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt")) {
            this.make_container(string);
        }
        if (string2.equals("http://www.w3.org/2000/01/rdf-schema#Container")) {
            this.make_container(string);
        }
    }

    private RDF_Class make_class(String string) {
        RDF_Class rDF_Class;
        Object object = this.existing.get(string);
        if (object instanceof RDF_Resource) {
            if (!(object instanceof RDF_Class)) {
                if (object instanceof RDF_Property) {
                    this.e.emit_error(3, 4, string, "Model.make_class");
                }
                if (object instanceof RDF_Statement) {
                    this.e.emit_error(3, 7, string, "Model.make_class");
                }
                if (object instanceof RDF_Container) {
                    this.e.emit_error(3, 10, string, "Model.make_class");
                }
                rDF_Class = new RDF_Class((RDF_Resource)object);
                this.existing.put(string, rDF_Class);
            } else {
                rDF_Class = (RDF_Class)object;
            }
        } else {
            rDF_Class = new RDF_Class((Resource)object);
            this.existing.put(string, rDF_Class);
        }
        return rDF_Class;
    }

    private RDF_MetaClass makeMetaClass(RDF_Class rDF_Class, int n) {
        RDF_MetaClass rDF_MetaClass = new RDF_MetaClass(rDF_Class, n);
        this.existing.put(rDF_MetaClass.getID(), rDF_MetaClass);
        return rDF_MetaClass;
    }

    private RDF_Property make_property(String string) {
        Object object = this.existing.get(string);
        RDF_Property rDF_Property = null;
        if (object instanceof RDF_Resource) {
            if (!(object instanceof RDF_Property)) {
                if (object instanceof RDF_Class) {
                    this.e.emit_error(3, 1, string, "Model.make_property");
                }
                if (object instanceof RDF_Statement) {
                    this.e.emit_error(3, 8, string, "Model.make_property");
                }
                if (object instanceof RDF_Container) {
                    this.e.emit_error(3, 11, string, "Model.make_property");
                }
                rDF_Property = new RDF_Property((RDF_Resource)object);
                this.existing.put(string, rDF_Property);
            } else {
                rDF_Property = (RDF_Property)object;
            }
        } else {
            rDF_Property = new RDF_Property((Resource)object);
            this.existing.put(string, rDF_Property);
        }
        return rDF_Property;
    }

    private void make_statement(String string) {
        Object object = this.existing.get(string);
        if (object instanceof RDF_Resource) {
            if (!(object instanceof RDF_Statement)) {
                if (object instanceof RDF_Class) {
                    this.e.emit_error(3, 2, string, "Model.make_statement");
                }
                if (object instanceof RDF_Property) {
                    this.e.emit_error(3, 5, string, "Model.make_statement");
                }
                if (object instanceof RDF_Container) {
                    this.e.emit_error(3, 12, string, "Model.make_statement");
                }
                RDF_Statement rDF_Statement = new RDF_Statement((RDF_Resource)object);
                this.existing.put(string, rDF_Statement);
            }
        } else {
            RDF_Statement rDF_Statement = new RDF_Statement((Resource)object);
            this.existing.put(string, rDF_Statement);
        }
    }

    private void make_container(String string) {
        Object object = this.existing.get(string);
        if (object instanceof RDF_Resource) {
            if (!(object instanceof RDF_Container)) {
                if (object instanceof RDF_Class) {
                    this.e.emit_error(3, 3, string, "Model.make_container");
                }
                if (object instanceof RDF_Property) {
                    this.e.emit_error(3, 6, string, "Model.make_container");
                }
                if (object instanceof RDF_Statement) {
                    this.e.emit_error(3, 9, string, "Model.make_container");
                }
                RDF_Container rDF_Container = new RDF_Container((RDF_Resource)object);
                this.existing.put(string, rDF_Container);
            }
        } else {
            RDF_Container rDF_Container = new RDF_Container((Resource)object);
            this.existing.put(string, rDF_Container);
        }
    }

    public ArrayList getStatements() {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        Collection collection = this.existing.values();
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            int n;
            Resource resource;
            int n2;
            Literal literal;
            int n3;
            Object object2;
            Object e = iterator.next();
            if (e instanceof RDF_Resource) {
                RDF_Resource rDF_Resource = (RDF_Resource)e;
                object2 = rDF_Resource.getcomment();
                n3 = 0;
                while (n3 < ((ArrayList)object2).size()) {
                    literal = (Literal)((ArrayList)object2).get(n3++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#comment", rDF_Resource.getID(), literal));
                }
                object2 = rDF_Resource.getlabel();
                int n4 = 0;
                while (n4 < ((ArrayList)object2).size()) {
                    literal = (Literal)((ArrayList)object2).get(n4++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#label", rDF_Resource.getID(), literal));
                }
                object2 = rDF_Resource.getseeAlso();
                n2 = 0;
                while (n2 < ((ArrayList)object2).size()) {
                    resource = (Resource)((ArrayList)object2).get(n2++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#seeAlso", rDF_Resource.getID(), resource.getID()));
                }
                object2 = rDF_Resource.getisDefinedBy();
                n = 0;
                while (n < ((ArrayList)object2).size()) {
                    resource = (Resource)((ArrayList)object2).get(n++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#isDefinedBy", rDF_Resource.getID(), resource.getID()));
                }
                object2 = rDF_Resource.getvalue();
                int n5 = 0;
                while (n5 < ((ArrayList)object2).size()) {
                    if ((object = ((ArrayList)object2).get(n5++)) instanceof Resource) {
                        arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#value", rDF_Resource.getID(), ((Resource)object).getID()));
                        continue;
                    }
                    arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#value", rDF_Resource.getID(), (Literal)object));
                }
                object2 = rDF_Resource.gettype();
                int n6 = 0;
                while (n6 < ((ArrayList)object2).size()) {
                    resource = (Resource)((ArrayList)object2).get(n6++);
                    arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", rDF_Resource.getID(), resource.getID()));
                }
            }
            if (e instanceof RDF_Class) {
                RDF_Class rDF_Class = (RDF_Class)e;
                object2 = rDF_Class.getsubClassOf();
                n3 = 0;
                while (n3 < ((ArrayList)object2).size()) {
                    RDF_Class rDF_Class2 = (RDF_Class)((ArrayList)object2).get(n3++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#subClassOf", rDF_Class.getID(), rDF_Class2.getID()));
                }
            }
            if (e instanceof RDF_Property) {
                RDF_Property rDF_Property = (RDF_Property)e;
                object2 = rDF_Property.getsubPropertyOf();
                n3 = 0;
                while (n3 < ((ArrayList)object2).size()) {
                    resource = (Resource)((ArrayList)object2).get(n3++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#subPropertyOf", rDF_Property.getID(), resource.getID()));
                }
                object2 = rDF_Property.getdomain();
                int n7 = 0;
                while (n7 < ((ArrayList)object2).size()) {
                    resource = (Resource)((ArrayList)object2).get(n7++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#domain", rDF_Property.getID(), resource.getID()));
                }
                object2 = rDF_Property.getlink();
                n2 = 0;
                while (n2 < ((ArrayList)object2).size()) {
                    Link link = (Link)((ArrayList)object2).get(n2++);
                    object = link.getobject();
                    resource = (Resource)link.getsubject();
                    if (!(object instanceof Literal)) {
                        Resource resource2 = (Resource)object;
                        arrayList.add(new Triple(rDF_Property.getID(), resource.getID(), resource2.getID()));
                        continue;
                    }
                    literal = (Literal)object;
                    arrayList.add(new Triple(rDF_Property.getID(), resource.getID(), literal));
                }
                object2 = rDF_Property.getrange();
                n = 0;
                while (n < ((ArrayList)object2).size()) {
                    resource = (Resource)((ArrayList)object2).get(n++);
                    arrayList.add(new Triple("http://www.w3.org/2000/01/rdf-schema#range", rDF_Property.getID(), resource.getID()));
                }
            }
            if (e instanceof RDF_Statement) {
                RDF_Statement rDF_Statement = (RDF_Statement)e;
                if (rDF_Statement.getsubject() != null) {
                    resource = (Resource)rDF_Statement.getsubject();
                    arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", rDF_Statement.getID(), resource.getID()));
                }
                if (rDF_Statement.getpredicate() != null) {
                    object2 = rDF_Statement.getpredicate();
                    arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", rDF_Statement.getID(), ((Resource)object2).getID()));
                }
                if (rDF_Statement.getobject() != null) {
                    object = rDF_Statement.getobject();
                    if (object instanceof Literal) {
                        literal = (Literal)object;
                        arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#object", rDF_Statement.getID(), literal));
                    } else {
                        arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#object", rDF_Statement.getID(), ((Resource)object).getID()));
                    }
                }
            }
            if (!(e instanceof RDF_Container)) continue;
            object2 = (RDF_Container)e;
            ArrayList arrayList2 = ((RDF_Container)object2).getmember();
            int n8 = 0;
            while (n8 < arrayList2.size()) {
                n2 = n8;
                ++n2;
                if ((object = arrayList2.get(n8++)) instanceof Resource) {
                    arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + n2, ((Resource)object2).getID(), ((Resource)object).getID()));
                    continue;
                }
                arrayList.add(new Triple("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + n2, ((Resource)object2).getID(), (Literal)object));
            }
        }
        return arrayList;
    }

    public int printStatements() {
        int n = 0;
        Output output = new Output();
        ArrayList arrayList = this.getStatements();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            String string = triple.getObject() instanceof Literal ? ((Literal)triple.getObject()).getvalue() : triple.getObject().toString();
            output.outln("Triple" + ++n + ": " + triple.getPredicate() + ", " + triple.getSubject() + ", " + string, true);
        }
        return n;
    }

    public int[] getStatistics() {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Collection collection = this.existing.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n9;
            int n10;
            int n11;
            Object e = iterator.next();
            if (e instanceof RDF_Resource) {
                RDF_Resource rDF_Resource = (RDF_Resource)e;
                object = rDF_Resource.getcomment();
                n11 = 0;
                while (n11 < ((ArrayList)object).size()) {
                    ++n;
                    ++n11;
                }
                object = rDF_Resource.getlabel();
                n10 = 0;
                while (n10 < ((ArrayList)object).size()) {
                    ++n;
                    ++n10;
                }
                object = rDF_Resource.getseeAlso();
                n9 = 0;
                while (n9 < ((ArrayList)object).size()) {
                    ++n;
                    ++n9;
                }
                object = rDF_Resource.getisDefinedBy();
                int n12 = 0;
                while (n12 < ((ArrayList)object).size()) {
                    ++n;
                    ++n12;
                }
                object = rDF_Resource.getvalue();
                int n13 = 0;
                while (n13 < ((ArrayList)object).size()) {
                    ++n;
                    ++n13;
                }
                object = rDF_Resource.gettype();
                int n14 = 0;
                while (n14 < ((ArrayList)object).size()) {
                    ++n;
                    ++n14;
                }
            }
            if (e instanceof RDF_Class) {
                RDF_Class rDF_Class = (RDF_Class)e;
                object = rDF_Class.getsubClassOf();
                n11 = 0;
                while (n11 < ((ArrayList)object).size()) {
                    ++n;
                    ++n11;
                }
                if (rDF_Class.getID().startsWith(this.BaseURI)) {
                    ++n2;
                } else {
                    ++n3;
                }
            }
            if (e instanceof RDF_Property) {
                RDF_Property rDF_Property = (RDF_Property)e;
                object = rDF_Property.getsubPropertyOf();
                n11 = 0;
                while (n11 < ((ArrayList)object).size()) {
                    ++n;
                    ++n11;
                }
                object = rDF_Property.getdomain();
                n10 = 0;
                while (n10 < ((ArrayList)object).size()) {
                    ++n;
                    ++n10;
                }
                object = rDF_Property.getlink();
                n9 = 0;
                while (n9 < ((ArrayList)object).size()) {
                    Link link = (Link)((ArrayList)object).get(n9++);
                    ++n;
                }
                if (rDF_Property.getrange() != null) {
                    ++n;
                }
                if (rDF_Property.getID().startsWith(this.BaseURI)) {
                    ++n4;
                } else {
                    ++n5;
                }
            }
            if (e instanceof RDF_Statement) {
                RDF_Statement rDF_Statement = (RDF_Statement)e;
                if (rDF_Statement.getsubject() != null) {
                    ++n;
                }
                if (rDF_Statement.getpredicate() != null) {
                    ++n;
                }
                if (rDF_Statement.getobject() != null) {
                    ++n;
                }
                ++n7;
            }
            if (!(e instanceof RDF_Container)) continue;
            object = (RDF_Container)e;
            ArrayList arrayList = ((RDF_Container)object).getmember();
            n10 = 0;
            while (n10 < arrayList.size()) {
                n9 = n10;
                ++n9;
                ++n;
                ++n10;
            }
            ++n6;
        }
        int n15 = this.existing.size();
        n8 = n15 - (n2 + n3 + n4 + n5 + n6 + n7);
        object = new int[]{n, n2, n3, n4, n5, n7, n6, n8};
        int n16 = 0;
        while (n16 < ((Object)object).length) {
            if (this.verbose) {
                System.out.println((int)object[n16]);
            }
            ++n16;
        }
        return object;
    }

    public void printStatistics() {
        int[] nArray = this.getStatistics();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nStatistics about triples, schema and data resources\n");
        stringBuffer.append("------------------------------------------------------\n");
        stringBuffer.append("\tNumber of triples " + nArray[0] + "\n");
        stringBuffer.append("\tNumber of Classes declared in this NS " + nArray[1] + "\n");
        stringBuffer.append("\tNumber of external Classes used in this NS " + nArray[2] + "\n");
        stringBuffer.append("\tNumber of Properties declared in this NS " + nArray[3] + "\n");
        stringBuffer.append("\tNumber of external Properties used in this NS " + nArray[4] + "\n");
        stringBuffer.append("\tNumber of Containers " + nArray[5] + "\n");
        stringBuffer.append("\tNumber of Reified Statements " + nArray[6] + "\n");
        stringBuffer.append("\tNumber of Resources (above resources are excluded) " + nArray[7] + "\n");
        Output output = new Output();
        output.out(stringBuffer.toString(), true);
    }

    public String genSysID() {
        String string = "genID:" + this.anonymos;
        ++this.anonymos;
        return string;
    }

    public void setBaseURI(String string) {
        this.BaseURI = string;
        this.namespaces.put(string, new Namespace(string));
    }

    public String getBaseURI() {
        return this.BaseURI;
    }

    public void dump() {
        Literal literal;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        Iterator iterator2;
        ArrayList arrayList;
        Object object5;
        Object object6;
        StringBuffer stringBuffer = new StringBuffer();
        Output output = new Output();
        output.out("\nThe classes of the Model: ", true);
        Collection collection = this.existing.values();
        Iterator iterator3 = collection.iterator();
        while (iterator3.hasNext()) {
            object6 = iterator3.next();
            if (!(object6 instanceof RDF_Class)) continue;
            object5 = (RDF_Class)object6;
            stringBuffer.append("\n" + ((Resource)object5).getID());
            arrayList = ((RDF_Class)object5).getsubClassOf();
            stringBuffer.append("\n\tsubClassOf: ");
            iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append(((Resource)iterator2.next()).getID() + " ");
            }
            stringBuffer.append(this.rdf_res_dump((RDF_Resource)object5));
            output.out(stringBuffer.toString(), true);
            stringBuffer.delete(0, stringBuffer.length());
        }
        output.out("\nThe properties of the Model: ", true);
        collection = this.existing.values();
        object6 = collection.iterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            if (!(object5 instanceof RDF_Property)) continue;
            iterator2 = (RDF_Property)object5;
            stringBuffer.append("\n" + ((Resource)((Object)iterator2)).getID());
            arrayList = ((RDF_Property)((Object)iterator2)).getrange();
            stringBuffer.append("\n\trange: ");
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Resource)iterator.next()).getID() + ", ");
            }
            arrayList = ((RDF_Property)((Object)iterator2)).getdomain();
            stringBuffer.append("\n\tdomain: ");
            object4 = arrayList.iterator();
            while (object4.hasNext()) {
                stringBuffer.append(((Resource)object4.next()).getID() + ", ");
            }
            arrayList = ((RDF_Property)((Object)iterator2)).getsubPropertyOf();
            stringBuffer.append("\n\tsubPropertyOf: ");
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                stringBuffer.append(((Resource)object3.next()).getID() + ", ");
            }
            stringBuffer.append("\n\tlinks: ");
            object2 = ((RDF_Property)((Object)iterator2)).getlink();
            int n = 0;
            while (n < ((ArrayList)object2).size()) {
                Link link = (Link)((ArrayList)object2).get(n++);
                object = link.getobject();
                Resource resource = (Resource)link.getsubject();
                if (object instanceof Literal) {
                    literal = (Literal)object;
                    stringBuffer.append("(" + resource.getID() + ", " + literal.toString() + ") ");
                    continue;
                }
                Resource resource2 = (Resource)object;
                stringBuffer.append("(" + resource.getID() + ", " + resource2.getID() + ") ");
            }
            stringBuffer.append(this.rdf_res_dump((RDF_Resource)((Object)iterator2)));
            output.out(stringBuffer.toString(), true);
            stringBuffer.delete(0, stringBuffer.length());
        }
        output.out("\nThe statements of the Model: ", true);
        collection = this.existing.values();
        object5 = collection.iterator();
        while (object5.hasNext()) {
            iterator2 = object5.next();
            if (!(iterator2 instanceof RDF_Statement)) continue;
            iterator = (RDF_Statement)((Object)iterator2);
            stringBuffer.append("\n" + ((Resource)((Object)iterator)).getID());
            stringBuffer.append("\n\tpredicate: " + ((RDF_Statement)((Object)iterator)).getpredicate().getID());
            stringBuffer.append("\n\tsubject: " + ((Resource)((RDF_Statement)((Object)iterator)).getsubject()).getID());
            object = ((RDF_Statement)((Object)iterator)).getobject();
            if (object instanceof Literal) {
                literal = (Literal)object;
                stringBuffer.append("\n\tobject: " + literal.toString());
            } else {
                object4 = (Resource)object;
                stringBuffer.append("\n\tobject: " + ((Resource)object4).getID());
            }
            stringBuffer.append(this.rdf_res_dump((RDF_Resource)((Object)iterator)));
            output.out(stringBuffer.toString(), true);
            stringBuffer.delete(0, stringBuffer.length());
        }
        output.out("\nThe containers of the Model: ", true);
        collection = this.existing.values();
        iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            if (!(iterator instanceof RDF_Container)) continue;
            object4 = (RDF_Container)((Object)iterator);
            stringBuffer.append("\n" + ((Resource)object4).getID());
            stringBuffer.append("\n\tmembers: " + ((RDF_Container)object4).getmember());
            stringBuffer.append(this.rdf_res_dump((RDF_Resource)object4));
            output.out(stringBuffer.toString(), true);
            stringBuffer.delete(0, stringBuffer.length());
        }
        output.out("\nThe rdf_resources of the Model: ", true);
        collection = this.existing.values();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            if (!(object4 instanceof RDF_Resource) || object4 instanceof RDF_Class || object4 instanceof RDF_Property || object4 instanceof RDF_Statement || object4 instanceof RDF_Container) continue;
            object3 = (RDF_Resource)object4;
            stringBuffer.append("\n" + ((Resource)object3).getID());
            stringBuffer.append(this.rdf_res_dump((RDF_Resource)object3));
            output.out(stringBuffer.toString(), true);
            stringBuffer.delete(0, stringBuffer.length());
        }
        output.out("\nThe resources of the Model: ", true);
        collection = this.existing.values();
        object4 = collection.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            if (!(object3 instanceof Resource) || object3 instanceof RDF_Resource) continue;
            object2 = (Resource)object3;
            output.out("\n" + ((Resource)object2).getID(), true);
        }
    }

    private String rdf_res_dump(RDF_Resource rDF_Resource) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tcomment: ");
        ArrayList arrayList = rDF_Resource.getcomment();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Literal)iterator.next()).toString() + ", ");
        }
        arrayList = rDF_Resource.getlabel();
        stringBuffer.append("\n\tlabel: ");
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append(((Literal)iterator2.next()).toString() + ", ");
        }
        arrayList = rDF_Resource.getseeAlso();
        stringBuffer.append("\n\tseeAlso: ");
        Iterator iterator3 = arrayList.iterator();
        while (iterator3.hasNext()) {
            stringBuffer.append(((Resource)iterator3.next()).getID() + ", ");
        }
        arrayList = rDF_Resource.getisDefinedBy();
        stringBuffer.append("\n\tisDefinedBy: ");
        Iterator iterator4 = arrayList.iterator();
        while (iterator4.hasNext()) {
            stringBuffer.append(((Resource)iterator4.next()).getID() + ", ");
        }
        arrayList = rDF_Resource.getvalue();
        stringBuffer.append("\n\tvalue: ");
        Iterator iterator5 = arrayList.iterator();
        while (iterator5.hasNext()) {
            object = iterator5.next();
            if (object instanceof Resource) {
                stringBuffer.append(((Resource)object).getID() + ", ");
                continue;
            }
            stringBuffer.append(((Literal)object).toString());
        }
        arrayList = rDF_Resource.gettype();
        stringBuffer.append("\n\ttype: ");
        object = arrayList.iterator();
        while (object.hasNext()) {
            stringBuffer.append(((Resource)object.next()).getID() + ", ");
        }
        return stringBuffer.toString();
    }

    private ArrayList getandadd(Model model, String string, String string2) {
        model.getandadd = true;
        ArrayList arrayList = new ArrayList();
        if (!this.existing.containsKey(string)) {
            this.e.emit_error(3, 43, "Resource: " + string + " NS: " + string2, "Model.getandadd");
        } else {
            Object object = this.existing.get(string);
            if (object instanceof RDF_Resource) {
                RDF_Resource rDF_Resource;
                if (object instanceof RDF_Class) {
                    rDF_Resource = (RDF_Class)object;
                    arrayList = this.getandadd_classinfo((RDF_Class)rDF_Resource, model);
                } else if (object instanceof RDF_Property) {
                    rDF_Resource = (RDF_Property)object;
                    arrayList = this.getandadd_propertyinfo((RDF_Property)rDF_Resource, model);
                } else if (this.verbose) {
                    System.out.println("The element you search for is only a RDF_Resource.");
                }
                rDF_Resource = (RDF_Resource)object;
                this.getandadd_rdf_resourceinfo(rDF_Resource, model);
            } else if (this.verbose) {
                System.out.println("The element you search for is only a Resource!");
            }
        }
        model.getandadd = false;
        return arrayList;
    }

    private ArrayList getandadd_classinfo(RDF_Class rDF_Class, Model model) {
        ArrayList arrayList = rDF_Class.getsubClassOf();
        int n = 0;
        while (n < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#subClassOf", rDF_Class.getID(), arrayList.get(n++).toString());
        }
        return arrayList;
    }

    private ArrayList getandadd_propertyinfo(RDF_Property rDF_Property, Model model) {
        ArrayList arrayList = rDF_Property.getdomain();
        int n = 0;
        while (n < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#domain", rDF_Property.getID(), arrayList.get(n++).toString());
        }
        arrayList = rDF_Property.getrange();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#range", rDF_Property.getID(), arrayList.get(n2++).toString());
        }
        arrayList = rDF_Property.getsubPropertyOf();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#subPropertyOf", rDF_Property.getID(), arrayList.get(n3++).toString());
        }
        return arrayList;
    }

    private void getandadd_rdf_resourceinfo(RDF_Resource rDF_Resource, Model model) {
        ArrayList arrayList = rDF_Resource.getcomment();
        int n = 0;
        while (n < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#comment", rDF_Resource.getID(), (Literal)arrayList.get(n++));
        }
        arrayList = rDF_Resource.getlabel();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#label", rDF_Resource.getID(), (Literal)arrayList.get(n2++));
        }
        arrayList = rDF_Resource.getseeAlso();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#seeAlso", rDF_Resource.getID(), arrayList.get(n3++).toString());
        }
        arrayList = rDF_Resource.getisDefinedBy();
        int n4 = 0;
        while (n4 < arrayList.size()) {
            model.addStatement("http://www.w3.org/2000/01/rdf-schema#isDefinedBy", rDF_Resource.getID(), arrayList.get(n4++).toString());
        }
        arrayList = rDF_Resource.gettype();
        int n5 = 0;
        while (n5 < arrayList.size()) {
            model.addStatement("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", rDF_Resource.getID(), arrayList.get(n5++).toString());
        }
    }

    public void solve_links() {
        Collection collection = this.existing.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof RDF_Resource) {
                ((RDF_Resource)e).solve_links(this.existing);
            }
            if (e instanceof RDF_Property) {
                ((RDF_Property)e).solve_links(this.existing);
            }
            if (e instanceof RDF_Container) {
                ((RDF_Container)e).solve_links(this.existing);
            }
            if (!(e instanceof RDF_Statement)) continue;
            ((RDF_Resource)e).solve_links(this.existing);
        }
    }

    public void castToMetaClass() {
        this.castToMetaClass(0);
        this.castToMetaClass(1);
    }

    private void castToMetaClass(int n) {
        Resource resource = null;
        resource = n == 0 ? this.getResource("http://www.w3.org/2000/01/rdf-schema#Class") : this.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        if (resource != null && resource instanceof RDF_Class) {
            RDF_Class rDF_Class = (RDF_Class)resource;
            HashSet hashSet = this.get_subClassesOf(rDF_Class);
            hashSet.add(rDF_Class);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                RDF_Class rDF_Class2;
                Object e = iterator.next();
                if (!(e instanceof RDF_Class) || (rDF_Class2 = (RDF_Class)e) instanceof RDF_MetaClass) continue;
                RDF_MetaClass rDF_MetaClass = null;
                rDF_MetaClass = n == 0 ? this.makeMetaClass(rDF_Class2, 0) : this.makeMetaClass(rDF_Class2, 1);
                this.restoreClassMetaClassReference(rDF_Class2, rDF_MetaClass);
            }
        }
    }

    private void restoreClassMetaClassReference(Resource resource, Resource resource2) {
        Object var3_3 = null;
        RDF_Resource rDF_Resource = null;
        RDF_Class rDF_Class = null;
        RDF_Property rDF_Property = null;
        Collection collection = this.getNodes();
        HashSet hashSet = new HashSet(collection);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList;
            Object e = iterator.next();
            if (e instanceof RDF_Resource && (arrayList = (rDF_Resource = (RDF_Resource)e).gettype()).contains(resource)) {
                arrayList.remove(resource);
                rDF_Resource.addtype((RDF_Class)resource2, this.existing);
            }
            if (e instanceof RDF_Class && (arrayList = (rDF_Class = (RDF_Class)e).getsubClassOf()).contains(resource)) {
                arrayList.remove(resource);
                rDF_Class.addsubClassOf((RDF_Class)resource2);
            }
            if (!(e instanceof RDF_Property)) continue;
            rDF_Property = (RDF_Property)e;
            arrayList = rDF_Property.getdomain();
            if (arrayList.contains(resource)) {
                arrayList.remove(resource);
                rDF_Property.adddomain((RDF_Class)resource2);
            }
            if (!(arrayList = rDF_Property.getrange()).contains(resource)) continue;
            arrayList.remove(resource);
            rDF_Property.addrange((RDF_Class)resource2);
        }
    }

    public void setResourceRoot(boolean bl) {
        Collection collection = this.getClasses();
        RDF_Class rDF_Class = null;
        Resource resource = this.getResource("http://www.w3.org/2000/01/rdf-schema#Resource");
        Resource resource2 = this.getResource("http://www.w3.org/2000/01/rdf-schema#Class");
        Resource resource3 = this.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        rDF_Class = resource == null || !(resource instanceof RDF_Class) ? this.make_class("http://www.w3.org/2000/01/rdf-schema#Resource") : (RDF_Class)resource;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDF_Class rDF_Class2 = (RDF_Class)iterator.next();
            int n = rDF_Class2.getsubClassOf().size();
            if (n != 0 || rDF_Class2 == resource2 || rDF_Class2 == resource3 || rDF_Class2 == rDF_Class || !bl && (bl || !rDF_Class2.getID().startsWith(this.getBaseURI()))) continue;
            rDF_Class2.addsubClassOf(rDF_Class);
        }
    }

    private void splitToNamespaces() {
        Collection collection = this.existing.values();
        Iterator iterator = collection.iterator();
        block0: while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = ((Resource)e).getID();
            Collection collection2 = this.namespaces.values();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                Namespace namespace = (Namespace)iterator2.next();
                if (!string.startsWith(namespace.getURI())) continue;
                namespace.addName((Resource)e);
                continue block0;
            }
        }
    }

    public Model getModelPart(HashSet hashSet) {
        Object object;
        Resource resource;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.splitToNamespaces();
        Model model = new Model(false);
        model.setBaseURI(this.getBaseURI());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object5 = (Namespace)iterator.next();
            hashMap.put(((Namespace)object5).getURI(), object5);
        }
        model.setNamespaces(hashMap);
        object5 = hashSet.iterator();
        while (object5.hasNext()) {
            object4 = (Namespace)object5.next();
            object3 = ((Namespace)object4).getNames();
            object2 = ((HashSet)object3).iterator();
            while (object2.hasNext()) {
                RDF_Resource rDF_Resource;
                int n;
                ArrayList arrayList;
                resource = (Resource)object2.next();
                model.existing.put(resource.getID(), resource);
                if (resource instanceof RDF_Class) {
                    object = (RDF_Class)resource;
                    arrayList = ((RDF_Class)object).getsubClassOf();
                    n = 0;
                    while (n < arrayList.size()) {
                        if (Namespace.isDefinedINNamespace(rDF_Resource = (RDF_Class)arrayList.get(n++), hashSet)) continue;
                        arrayList.remove(rDF_Resource);
                    }
                }
                if (resource instanceof RDF_Property) {
                    object = (RDF_Property)resource;
                    arrayList = ((RDF_Property)object).getsubPropertyOf();
                    n = 0;
                    while (n < arrayList.size()) {
                        if (Namespace.isDefinedINNamespace(rDF_Resource = (RDF_Property)arrayList.get(n++), hashSet)) continue;
                        arrayList.remove(rDF_Resource);
                    }
                    this.removeDR((RDF_Property)resource, model, hashSet);
                }
                if (!(resource instanceof RDF_Class) && !(resource instanceof RDF_Property)) continue;
                object = (RDF_Resource)resource;
                arrayList = ((RDF_Resource)object).gettype();
                n = 0;
                while (n < arrayList.size()) {
                    if (Namespace.isDefinedINNamespace(rDF_Resource = (RDF_Class)arrayList.get(n++), hashSet)) continue;
                    arrayList.remove(rDF_Resource);
                }
            }
        }
        object4 = this.getNodes();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (Resource)object3.next();
            if (object2 instanceof RDF_Class || object2 instanceof RDF_Property) continue;
            model.existing.put(((Resource)object2).getID(), object2);
            if (!(object2 instanceof RDF_Resource)) continue;
            resource = (RDF_Resource)object2;
            object = ((RDF_Resource)resource).gettype();
            int n = 0;
            while (n < ((ArrayList)object).size()) {
                RDF_Class rDF_Class;
                if (Namespace.isDefinedINNamespace(rDF_Class = (RDF_Class)((ArrayList)object).get(n++), hashSet)) continue;
                ((ArrayList)object).remove(rDF_Class);
            }
        }
        return model;
    }

    private void removeDR(RDF_Property rDF_Property, Model model, HashSet hashSet) {
        Object object;
        ArrayList arrayList = rDF_Property.getdomain();
        int n = 0;
        while (n < arrayList.size()) {
            if (Namespace.isDefinedINNamespace((Resource)(object = (RDF_Class)arrayList.get(n++)), hashSet)) continue;
            arrayList.remove(object);
        }
        object = rDF_Property.getrange();
        int n2 = 0;
        while (n2 < ((ArrayList)object).size()) {
            RDF_Class rDF_Class;
            if (Namespace.isDefinedINNamespace(rDF_Class = (RDF_Class)((ArrayList)object).get(n2++), hashSet)) continue;
            ((ArrayList)object).remove(rDF_Class);
        }
    }
}

