/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.corevrp.model;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import gr.forth.ics.vrp.corevrp.model.Existing;
import gr.forth.ics.vrp.corevrp.model.Literal;
import gr.forth.ics.vrp.corevrp.model.RDF_Class;
import gr.forth.ics.vrp.corevrp.model.RDF_Resource;
import gr.forth.ics.vrp.corevrp.model.Resource;
import java.util.ArrayList;
import java.util.Iterator;

public class Link {
    private Object subject;
    private Object object;

    Link() {
    }

    Link(int n, int n2) {
        this.subject = new Integer(n);
        this.object = new Integer(n2);
    }

    Link(int n, Literal literal) {
        this.subject = new Integer(n);
        this.object = literal;
    }

    int getsubject_int() {
        if (this.subject instanceof Integer) {
            Integer n = (Integer)this.subject;
            return n;
        }
        return -1;
    }

    public Object getsubject() {
        return this.subject;
    }

    void setsubject(int n) {
        this.subject = new Integer(n);
    }

    public void setsubject(Resource resource) {
        this.subject = resource;
    }

    public Object getobject() {
        return this.object;
    }

    void setobject(int n) {
        this.object = new Integer(n);
    }

    public void setobject(Resource resource) {
        this.object = resource;
    }

    public void setobject(Literal literal) {
        this.object = literal;
    }

    public void solve_links(Existing existing) {
        if (this.subject instanceof Integer) {
            this.subject = existing.get((Integer)this.subject);
        }
        if (this.object instanceof Integer) {
            this.object = existing.get((Integer)this.object);
        }
    }

    public boolean domain_range_check(ArrayList arrayList, ArrayList arrayList2) throws Exception {
        this.domain_check(arrayList);
        this.range_check(arrayList2);
        return true;
    }

    private boolean range_check(ArrayList arrayList) throws Exception {
        Object object;
        if (arrayList.size() <= 0) {
            return true;
        }
        boolean bl = false;
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        if (this.getobject() instanceof Literal) {
            bl = true;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (RDF_Class)iterator.next();
            arrayList2.add(((Resource)object).getID());
            if (bl) {
                String string;
                if (((Resource)object).getID().equals("http://www.w3.org/2000/01/rdf-schema#Literal")) {
                    return true;
                }
                if (((Resource)object).getID().startsWith("http://www.w3.org/2001/XMLSchema#") && Link.checkLiteralType(string = ((Literal)this.getobject()).getvalue(), ((Resource)object).getID())) {
                    return true;
                }
                if (!((RDF_Class)object).containssubClassOf_type("http://www.w3.org/2000/01/rdf-schema#Literal")) continue;
                return true;
            }
            if (!(this.getobject() instanceof RDF_Resource ? ((RDF_Resource)this.getobject()).has_type((RDF_Class)object) : ((Resource)object).getID().equals("http://www.w3.org/2000/01/rdf-schema#Resource"))) continue;
            return true;
        }
        object = "";
        object = bl ? ((Literal)this.getobject()).getvalue() : ((Resource)this.getobject()).getID();
        throw new Exception("range error: " + (String)object + " should be of type " + arrayList2 + " ");
    }

    private boolean domain_check(ArrayList arrayList) throws Exception {
        if (arrayList.size() <= 0) {
            return true;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RDF_Class rDF_Class = (RDF_Class)iterator.next();
            arrayList2.add(rDF_Class.getID());
            if (!(this.getsubject() instanceof RDF_Resource ? ((RDF_Resource)this.getsubject()).has_type(rDF_Class) : rDF_Class.getID().equals("http://www.w3.org/2000/01/rdf-schema#Resource"))) continue;
            return true;
        }
        throw new Exception("domain error: " + ((Resource)this.getobject()).getID() + " should be of type " + arrayList2 + " ");
    }

    public static boolean checkLiteralType(String string, String string2) {
        int n = string2.indexOf("#");
        if (n >= 0) {
            string2 = string2.substring(++n);
        }
        try {
            XSDatatype xSDatatype = DatatypeFactory.getTypeByName((String)string2);
            return xSDatatype.isValid(string, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
    }
}

