/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.corevrp.broker;

import gr.forth.ics.vrp.corevrp.model.Link;
import gr.forth.ics.vrp.corevrp.model.Model;
import gr.forth.ics.vrp.corevrp.model.RDF_Class;
import gr.forth.ics.vrp.corevrp.model.RDF_DAG;
import gr.forth.ics.vrp.corevrp.model.RDF_Property;
import gr.forth.ics.vrp.corevrp.model.RDF_Resource;
import gr.forth.ics.vrp.corevrp.model.Resource;
import gr.forth.ics.vrp.corevrp.validator.RDF_Validator;
import gr.forth.ics.vrp.corevrp.vocabulary.XMLSchema_DT;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class RDF_SemanticBroker {
    private Model basic_model;
    private RDF_Validator validator;
    private Collection allClasses;
    private Collection allProperties;
    private Collection allResources;
    private Collection attributeClasses;
    private Collection metaClasses;
    private Collection propertyClasses;
    private Collection containerClasses;
    private Collection statementClasses;
    private HashMap superClasses = new HashMap();
    private HashMap subClasses = new HashMap();
    private HashMap domainProperties = new HashMap();
    private HashMap rangeProperties = new HashMap();
    private HashMap instanceResources = new HashMap();
    private HashMap superProperties = new HashMap();
    private HashMap subProperties = new HashMap();
    private HashMap namespaces = new HashMap();
    private int count = 1;

    public RDF_SemanticBroker(Model model, RDF_Validator rDF_Validator) {
        Object object;
        Object object2;
        this.basic_model = model;
        this.validator = rDF_Validator;
        this.allClasses = this.basic_model.getClasses();
        this.allProperties = this.basic_model.getProperties();
        this.metaClasses = this.basic_model.getMetaClasses();
        this.propertyClasses = this.basic_model.getMetaProperties();
        this.allResources = new ArrayList();
        Iterator iterator = this.basic_model.getNodes().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof RDF_Class || object2 instanceof RDF_Property || !(object2 instanceof RDF_Resource)) continue;
            this.allResources.add(object2);
        }
        this.attributeClasses = new HashSet();
        if (this.basic_model.contains("http://www.w3.org/2000/01/rdf-schema#Literal")) {
            object2 = (RDF_Class)this.basic_model.getResource("http://www.w3.org/2000/01/rdf-schema#Literal");
            this.attributeClasses.add(object2);
            this.attributeClasses.addAll(this.getSubClasses((RDF_Class)object2, true, false));
        }
        object2 = XMLSchema_DT.XMLSchemaDatatypes.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (!this.basic_model.contains((String)object)) continue;
            RDF_Class rDF_Class = (RDF_Class)this.basic_model.getResource((String)object);
            this.attributeClasses.add(rDF_Class);
            this.attributeClasses.addAll(this.getSubClasses(rDF_Class, true, false));
        }
        this.containerClasses = new HashSet();
        if (this.basic_model.contains("http://www.w3.org/2000/01/rdf-schema#Container")) {
            object = (RDF_Class)this.basic_model.getResource("http://www.w3.org/2000/01/rdf-schema#Container");
            this.containerClasses.add(object);
            this.containerClasses.addAll(this.getSubClasses((RDF_Class)object, true, false));
        }
        this.statementClasses = new HashSet();
        if (this.basic_model.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement")) {
            object = (RDF_Class)this.basic_model.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement");
            this.statementClasses.add(object);
            this.statementClasses.addAll(this.getSubClasses((RDF_Class)object, true, false));
        }
        this.initNamespaces();
    }

    public RDF_Resource getResourceByID(String string) {
        Resource resource = this.basic_model.getResource(string);
        if (resource instanceof RDF_Resource) {
            return (RDF_Resource)resource;
        }
        return null;
    }

    public Collection getAllClasses(boolean bl) {
        AbstractCollection abstractCollection = bl ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        abstractCollection.addAll(this.allClasses);
        return abstractCollection;
    }

    public RDF_Class getMetaClass(RDF_Class rDF_Class) {
        RDF_Class rDF_Class2 = null;
        Iterator iterator = rDF_Class.gettype().iterator();
        while (iterator.hasNext()) {
            rDF_Class2 = (RDF_Class)iterator.next();
            if (this.isMetaClass(rDF_Class2)) break;
        }
        return rDF_Class2;
    }

    private HashSet getSubFromDAG(RDF_DAG rDF_DAG, Object object) {
        ArrayList arrayList = (ArrayList)rDF_DAG.getdag().get(object);
        return (HashSet)arrayList.get(0);
    }

    private HashSet getSuperFromDAG(RDF_DAG rDF_DAG, Object object) {
        ArrayList arrayList = (ArrayList)rDF_DAG.getdag().get(object);
        return (HashSet)arrayList.get(1);
    }

    public Collection getSubClasses(RDF_Class rDF_Class, boolean bl, boolean bl2) {
        AbstractCollection abstractCollection = bl2 ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        if (bl && this.subClasses.containsKey(rDF_Class)) {
            abstractCollection.addAll((Collection)this.subClasses.get(rDF_Class));
            return abstractCollection;
        }
        RDF_DAG rDF_DAG = this.validator.getsubClassOfDAG();
        HashSet hashSet = this.getSubFromDAG(rDF_DAG, rDF_Class);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        if (bl) {
            HashSet hashSet2 = new HashSet();
            Iterator iterator2 = abstractCollection.iterator();
            while (iterator2.hasNext()) {
                hashSet2.addAll(this.getSubClasses((RDF_Class)iterator2.next(), true, false));
            }
            abstractCollection.addAll(hashSet2);
            this.subClasses.put(rDF_Class, abstractCollection);
        }
        return abstractCollection;
    }

    public Collection getSuperClasses(RDF_Class rDF_Class, boolean bl, boolean bl2) {
        AbstractCollection abstractCollection = bl2 ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        if (bl && this.superClasses.containsKey(rDF_Class)) {
            abstractCollection.addAll((Collection)this.superClasses.get(rDF_Class));
            return abstractCollection;
        }
        RDF_DAG rDF_DAG = this.validator.getsubClassOfDAG();
        HashSet hashSet = this.getSuperFromDAG(rDF_DAG, rDF_Class);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        if (bl) {
            HashSet hashSet2 = new HashSet();
            Iterator iterator2 = abstractCollection.iterator();
            while (iterator2.hasNext()) {
                hashSet2.addAll(this.getSuperClasses((RDF_Class)iterator2.next(), true, false));
            }
            abstractCollection.addAll(hashSet2);
            this.superClasses.put(rDF_Class, abstractCollection);
        }
        return abstractCollection;
    }

    public Collection getRootClasses(boolean bl) {
        AbstractCollection abstractCollection = bl ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        HashSet hashSet = this.validator.getsubClassOfDAG().getroots();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        return abstractCollection;
    }

    public boolean isRootClass(RDF_Class rDF_Class) {
        return this.validator.getsubClassOfDAG().getroots().contains(rDF_Class);
    }

    public boolean isLeafClass(RDF_Class rDF_Class) {
        RDF_DAG rDF_DAG = this.validator.getsubClassOfDAG();
        return this.getSubFromDAG(rDF_DAG, rDF_Class).isEmpty();
    }

    public boolean isMetaClass(RDF_Class rDF_Class) {
        return this.metaClasses.contains(rDF_Class);
    }

    public boolean isPropertyClass(RDF_Class rDF_Class) {
        return this.propertyClasses.contains(rDF_Class);
    }

    public boolean isContainerClass(RDF_Class rDF_Class) {
        return this.containerClasses.contains(rDF_Class);
    }

    public boolean isStatementClass(RDF_Class rDF_Class) {
        return this.containerClasses.contains(rDF_Class);
    }

    public boolean isSchemaClass(RDF_Class rDF_Class) {
        return this.isMetaClass(rDF_Class) || this.isPropertyClass(rDF_Class);
    }

    public Collection getInstanceResources(RDF_Class rDF_Class, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        AbstractCollection abstractCollection = bl2 ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        if (bl && this.instanceResources.containsKey(rDF_Class)) {
            abstractCollection.addAll((Collection)this.instanceResources.get(rDF_Class));
            return abstractCollection;
        }
        Iterator iterator = this.allResources.iterator();
        while (iterator.hasNext()) {
            object2 = (RDF_Resource)iterator.next();
            object = ((RDF_Resource)object2).gettype();
            if (!object.contains(rDF_Class)) continue;
            abstractCollection.add(object2);
        }
        if (bl) {
            object2 = new HashSet();
            object = this.getSubClasses(rDF_Class, false, false).iterator();
            while (object.hasNext()) {
                ((AbstractCollection)object2).addAll(this.getInstanceResources((RDF_Class)object.next(), true, false));
            }
            abstractCollection.addAll(object2);
            this.instanceResources.put(rDF_Class, abstractCollection);
        }
        return abstractCollection;
    }

    public Collection getClassesOfMetaclass(RDF_Class rDF_Class, boolean bl) {
        AbstractCollection abstractCollection = bl ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        Iterator iterator = this.allClasses.iterator();
        while (iterator.hasNext()) {
            RDF_Class rDF_Class2 = (RDF_Class)iterator.next();
            ArrayList arrayList = rDF_Class2.gettype();
            if (!arrayList.contains(rDF_Class)) continue;
            abstractCollection.add(rDF_Class2);
        }
        return abstractCollection;
    }

    public Collection getPropertiesOfClass(RDF_Class rDF_Class, boolean bl) {
        AbstractCollection abstractCollection = bl ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        Iterator iterator = this.allProperties.iterator();
        while (iterator.hasNext()) {
            RDF_Property rDF_Property = (RDF_Property)iterator.next();
            ArrayList arrayList = rDF_Property.gettype();
            if (!arrayList.contains(rDF_Class)) continue;
            abstractCollection.add(rDF_Property);
        }
        return abstractCollection;
    }

    public Collection getPropertiesWithDomain(RDF_Class rDF_Class, boolean bl) {
        Object object;
        Object object2;
        if (bl && this.domainProperties.containsKey(rDF_Class)) {
            return (Collection)this.domainProperties.get(rDF_Class);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.allProperties.iterator();
        while (iterator.hasNext()) {
            object2 = (RDF_Property)iterator.next();
            object = ((RDF_Property)object2).getdomain();
            if (!object.contains(rDF_Class)) continue;
            arrayList.add(object2);
        }
        if (bl) {
            object2 = new HashSet();
            object = this.getSuperClasses(rDF_Class, false, false).iterator();
            while (object.hasNext()) {
                ((AbstractCollection)object2).addAll(this.getPropertiesWithDomain((RDF_Class)object.next(), true));
            }
            arrayList.addAll((Collection<Object>)object2);
            this.domainProperties.put(rDF_Class, arrayList);
        }
        return arrayList;
    }

    public Collection getPropertiesWithRange(RDF_Class rDF_Class, boolean bl) {
        Object object;
        Object object2;
        if (bl && this.rangeProperties.containsKey(rDF_Class)) {
            return (Collection)this.rangeProperties.get(rDF_Class);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.allProperties.iterator();
        while (iterator.hasNext()) {
            object2 = (RDF_Property)iterator.next();
            object = ((RDF_Property)object2).getrange();
            if (!object.contains(rDF_Class)) continue;
            arrayList.add(object2);
        }
        if (bl) {
            object2 = new HashSet();
            object = this.getSuperClasses(rDF_Class, false, false).iterator();
            while (object.hasNext()) {
                ((AbstractCollection)object2).addAll(this.getPropertiesWithRange((RDF_Class)object.next(), true));
            }
            arrayList.addAll((Collection<Object>)object2);
            this.rangeProperties.put(rDF_Class, arrayList);
        }
        return arrayList;
    }

    public Collection getAllProperties(boolean bl) {
        if (bl) {
            TreeSet treeSet = new TreeSet(new RDF_ResourceComparator());
            treeSet.addAll(this.allProperties);
            return treeSet;
        }
        return this.allProperties;
    }

    public Collection getRangeOfProperty(RDF_Property rDF_Property, boolean bl, boolean bl2) {
        AbstractCollection abstractCollection = bl2 ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        Iterator iterator = rDF_Property.getrange().iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        if (bl) {
            HashSet hashSet = new HashSet();
            Iterator iterator2 = abstractCollection.iterator();
            while (iterator2.hasNext()) {
                hashSet.addAll(this.getSubClasses((RDF_Class)iterator2.next(), true, false));
            }
            abstractCollection.addAll(hashSet);
        }
        return abstractCollection;
    }

    public Collection getDomainOfProperty(RDF_Property rDF_Property, boolean bl, boolean bl2) {
        AbstractCollection abstractCollection = bl2 ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        Iterator iterator = rDF_Property.getdomain().iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        if (bl) {
            HashSet hashSet = new HashSet();
            Iterator iterator2 = abstractCollection.iterator();
            while (iterator2.hasNext()) {
                hashSet.addAll(this.getSubClasses((RDF_Class)iterator2.next(), true, false));
            }
            abstractCollection.addAll(hashSet);
        }
        return abstractCollection;
    }

    public Collection getSubProperties(RDF_Property rDF_Property, boolean bl, boolean bl2) {
        AbstractCollection abstractCollection = bl2 ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        if (bl && this.subProperties.containsKey(rDF_Property)) {
            abstractCollection.addAll((Collection)this.subProperties.get(rDF_Property));
            return abstractCollection;
        }
        RDF_DAG rDF_DAG = this.validator.getsubPropertyOfDAG();
        HashSet hashSet = this.getSubFromDAG(rDF_DAG, rDF_Property);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        if (bl) {
            HashSet hashSet2 = new HashSet();
            Iterator iterator2 = abstractCollection.iterator();
            while (iterator2.hasNext()) {
                hashSet2.addAll(this.getSubProperties((RDF_Property)iterator2.next(), true, false));
            }
            abstractCollection.addAll(hashSet2);
            this.subProperties.put(rDF_Property, abstractCollection);
        }
        return abstractCollection;
    }

    public Collection getSuperProperties(RDF_Property rDF_Property, boolean bl, boolean bl2) {
        AbstractCollection abstractCollection = bl2 ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        if (bl && this.superProperties.containsKey(rDF_Property)) {
            abstractCollection.addAll((Collection)this.superProperties.get(rDF_Property));
            return abstractCollection;
        }
        RDF_DAG rDF_DAG = this.validator.getsubPropertyOfDAG();
        HashSet hashSet = this.getSuperFromDAG(rDF_DAG, rDF_Property);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        if (bl) {
            HashSet hashSet2 = new HashSet();
            Iterator iterator2 = abstractCollection.iterator();
            while (iterator2.hasNext()) {
                hashSet2.addAll(this.getSuperProperties((RDF_Property)iterator2.next(), true, false));
            }
            abstractCollection.addAll(hashSet2);
            this.superProperties.put(rDF_Property, abstractCollection);
        }
        return abstractCollection;
    }

    public RDF_Class getClassTypeOfProperty(RDF_Property rDF_Property) {
        RDF_Class rDF_Class = null;
        Iterator iterator = rDF_Property.gettype().iterator();
        while (iterator.hasNext()) {
            rDF_Class = (RDF_Class)iterator.next();
            if (this.isPropertyClass(rDF_Class)) break;
        }
        return rDF_Class;
    }

    public Collection getRootProperties(boolean bl) {
        AbstractCollection abstractCollection = bl ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        HashSet hashSet = this.validator.getsubPropertyOfDAG().getroots();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(iterator.next());
        }
        return abstractCollection;
    }

    public boolean isRootProperty(RDF_Property rDF_Property) {
        return this.validator.getsubPropertyOfDAG().getroots().contains(rDF_Property);
    }

    public boolean isLeafProperty(RDF_Property rDF_Property) {
        RDF_DAG rDF_DAG = this.validator.getsubPropertyOfDAG();
        return this.getSubFromDAG(rDF_DAG, rDF_Property).isEmpty();
    }

    public Collection getAllResources(boolean bl) {
        if (bl) {
            TreeSet treeSet = new TreeSet(new RDF_ResourceComparator());
            treeSet.addAll(this.allResources);
            return treeSet;
        }
        return this.allResources;
    }

    public Collection getClassTypes(RDF_Resource rDF_Resource, boolean bl) {
        AbstractCollection abstractCollection = bl ? new TreeSet(new RDF_ResourceComparator()) : new ArrayList();
        ArrayList arrayList = rDF_Resource.gettype();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!this.allClasses.contains(resource)) continue;
            abstractCollection.add(resource);
        }
        return abstractCollection;
    }

    public HashMap getLinksWithSubject(RDF_Resource rDF_Resource) {
        HashMap<Link, RDF_Property> hashMap = new HashMap<Link, RDF_Property>();
        Iterator iterator = this.getClassTypes(rDF_Resource, false).iterator();
        while (iterator.hasNext()) {
            RDF_Class rDF_Class = (RDF_Class)iterator.next();
            Iterator iterator2 = this.getPropertiesWithDomain(rDF_Class, true).iterator();
            while (iterator2.hasNext()) {
                RDF_Property rDF_Property = (RDF_Property)iterator2.next();
                Iterator iterator3 = rDF_Property.getlink().iterator();
                while (iterator3.hasNext()) {
                    Link link = (Link)iterator3.next();
                    if (!link.getsubject().equals(rDF_Resource)) continue;
                    hashMap.put(link, rDF_Property);
                }
            }
        }
        return hashMap;
    }

    public HashMap getLinksWithObject(RDF_Resource rDF_Resource) {
        HashMap<Link, RDF_Property> hashMap = new HashMap<Link, RDF_Property>();
        Iterator iterator = this.getClassTypes(rDF_Resource, false).iterator();
        while (iterator.hasNext()) {
            RDF_Class rDF_Class = (RDF_Class)iterator.next();
            Iterator iterator2 = this.getPropertiesWithRange(rDF_Class, true).iterator();
            while (iterator2.hasNext()) {
                RDF_Property rDF_Property = (RDF_Property)iterator2.next();
                Iterator iterator3 = rDF_Property.getlink().iterator();
                while (iterator3.hasNext()) {
                    Link link = (Link)iterator3.next();
                    if (!link.getobject().equals(rDF_Resource)) continue;
                    hashMap.put(link, rDF_Property);
                }
            }
        }
        return hashMap;
    }

    private String getURINamespacePrefix(String string) {
        int n = string.lastIndexOf(35);
        if (n != -1 && n != string.length() - 1) {
            return string.substring(0, ++n);
        }
        return "";
    }

    public boolean isBasicResource(RDF_Resource rDF_Resource) {
        String string = rDF_Resource.getID();
        return string.startsWith("http://www.w3.org/2000/01/rdf-schema#") || string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || string.startsWith("http://www.w3.org/2001/XMLSchema#");
    }

    public boolean isAttributeClass(RDF_Class rDF_Class) {
        return this.attributeClasses.contains(rDF_Class);
    }

    private void initNamespaces() {
        this.namespaces.put(this.basic_model.getBaseURI(), "ns");
        if (this.basic_model.getNamespaces().containsKey("http://www.w3.org/2000/01/rdf-schema#")) {
            this.namespaces.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        }
        if (this.basic_model.getNamespaces().containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            this.namespaces.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        }
        if (this.basic_model.getNamespaces().containsKey("http://www.w3.org/2001/XMLSchema#")) {
            this.namespaces.put("http://www.w3.org/2001/XMLSchema#", "xmls");
        }
    }

    public String getLabelFor(RDF_Resource rDF_Resource) {
        if (rDF_Resource == null) {
            return "";
        }
        String string = rDF_Resource.getID();
        if (rDF_Resource instanceof RDF_Class || rDF_Resource instanceof RDF_Property) {
            int n;
            String string2 = "";
            String string3 = this.getURINamespacePrefix(string);
            if (!string3.equals("")) {
                if (!this.namespaces.containsKey(string3)) {
                    this.namespaces.put(string3, "ext" + this.count);
                    ++this.count;
                }
                string2 = this.namespaces.get(string3) + ":";
            }
            if ((n = string.lastIndexOf(35)) != -1) {
                string = string2 + string.substring(n + 1);
            }
        } else {
            String string4 = this.getURINamespacePrefix(string);
            String string5 = (String)this.namespaces.get(string4);
            if (string5 != null) {
                int n = string.lastIndexOf("#");
                string = string5 + "#" + string.substring(n + 1);
                if (string.lastIndexOf("genID") != -1) {
                    string = string + " (anonymous)";
                }
            }
        }
        return string;
    }

    public String getNamespaceInfor() {
        String string = "Namespaces: ";
        Iterator iterator = this.namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + this.namespaces.get(string2) + "=\"" + string2 + "\"; ";
        }
        return string;
    }

    public class RDF_ResourceComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((Resource)object).getID().compareTo(((Resource)object2).getID());
        }

        public boolean equals(Object object) {
            return false;
        }
    }
}

