/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.corevrp;

import gr.forth.ics.vrp.corevrp.Output;
import gr.forth.ics.vrp.corevrp.RDF_Error;
import gr.forth.ics.vrp.corevrp.broker.RDF_SemanticBroker;
import gr.forth.ics.vrp.corevrp.model.Model;
import gr.forth.ics.vrp.corevrp.model.Namespace;
import gr.forth.ics.vrp.corevrp.model.RDF_DAG;
import gr.forth.ics.vrp.corevrp.parser.parser;
import gr.forth.ics.vrp.corevrp.validator.RDF_Validator;
import gr.forth.ics.vrp.statistics.RDFModelStatistics;
import gr.forth.ics.vrp.visualization.RDF_Visualization;
import gr.forth.ics.vrp.visualization.SVGGenerator;
import gr.forth.ics.vrp.vrpgui.ChooseOutNamespaceDialog;
import gr.forth.ics.vrp.vrpgui.MyPanel;
import gr.forth.ics.vrp.vrpgui.VRPPanel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;

public class Main {
    private static String OutputFile;
    private String inFile;
    public static parser p_all;
    public static int error_counter;
    private boolean debug = false;
    private boolean graph = false;
    private boolean svg = false;
    private boolean statements = false;
    private boolean triples = false;
    private boolean fetch_all = false;
    private boolean inheritance = false;
    private boolean typeInfer = false;
    private boolean fetch = false;
    private boolean only = false;
    private boolean verbose = false;
    private boolean classLoop = false;
    private boolean propertyLoop = false;
    private boolean subsetSubpropertyDomainRange = false;
    private boolean typing = false;
    private boolean sourceTargetTypes = false;
    private boolean[] modelStatistics = new boolean[]{false, false, false, false, false, false};
    private boolean timeStatistics = false;
    private boolean simple = false;
    private String svgoutput = "output.svg";
    private static boolean noerrormsg;
    private HashSet selectedNSURI = new HashSet();
    public static MyPanel gui;
    public static Output Print;
    public static int warning_counter;

    public static String getOutputFile() {
        return OutputFile;
    }

    public void setOutputFile(String string) {
        OutputFile = string;
    }

    public void setnoerrormsg(boolean bl) {
        noerrormsg = bl;
    }

    public static boolean getnoerrormsg() {
        return noerrormsg;
    }

    public void setclassLoop(boolean bl) {
        this.classLoop = bl;
    }

    public void settyping(boolean bl) {
        this.typing = bl;
    }

    public void setinheritance(boolean bl) {
        this.inheritance = bl;
    }

    public void setTypeInfer(boolean bl) {
        this.typeInfer = bl;
    }

    public void setpropertyLoop(boolean bl) {
        this.propertyLoop = bl;
    }

    public void setsourceTargetTypes(boolean bl) {
        this.sourceTargetTypes = bl;
    }

    public void setsubsetSubpropertyDomainRange(boolean bl) {
        this.subsetSubpropertyDomainRange = bl;
    }

    public void setfetch_all(boolean bl) {
        this.fetch_all = bl;
    }

    public void setdebug(boolean bl) {
        this.debug = bl;
    }

    public void setgraph(boolean bl) {
        this.graph = bl;
    }

    public void setsvg(boolean bl) {
        this.svg = bl;
    }

    public void setonly(boolean bl) {
        this.only = bl;
    }

    public void setsimple(boolean bl) {
        this.simple = bl;
    }

    public void setstatements(boolean bl) {
        this.statements = bl;
    }

    public void settriples(boolean bl) {
        this.triples = bl;
    }

    public void setverbose(boolean bl) {
        this.verbose = bl;
    }

    public void settimeStatistics(boolean bl) {
        this.timeStatistics = bl;
    }

    public void setSelectedNS(HashSet hashSet) {
        this.selectedNSURI = hashSet;
    }

    public void enableModelStatistics(int n, boolean bl) {
        this.modelStatistics[n] = bl;
    }

    public boolean isModelStatisticsEnabled(int n) {
        return this.modelStatistics[n];
    }

    public void setsvgoutput(String string) {
        this.svgoutput = string;
    }

    public void setsvgsize(int n, int n2) {
        SVGGenerator.setSVGSize(n, n2);
    }

    public void setGUI(MyPanel myPanel) {
        gui = myPanel;
    }

    private void clean_file(String string) throws Exception {
        PrintWriter printWriter = null;
        try {
            Object object;
            Closeable closeable;
            File file = new File(OutputFile);
            if (file.exists()) {
                try {
                    closeable = new BufferedReader(new InputStreamReader(System.in));
                    if (gui != null) {
                        ((VRPPanel)gui).clean_file_request(OutputFile);
                        VRPPanel cfr_ignored_0 = (VRPPanel)gui;
                        if (!VRPPanel.clean_file) {
                            throw new Exception("Main.clean_file Exception");
                        }
                    } else {
                        do {
                            System.out.println("Do you want to overwrite the file " + OutputFile + "? (y or n) ");
                            object = ((BufferedReader)closeable).readLine();
                            if (!((String)object).startsWith("n")) continue;
                            throw new Exception("Main.clean_file Exception");
                        } while (!((String)object).startsWith("y"));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            closeable = new FileWriter(OutputFile);
            if (!file.exists() || !file.canRead()) {
                Print.outln("geht nicht", false);
            }
            if (!file.canWrite()) {
                Print.outln("Not allowed to write!", false);
            }
            printWriter = new PrintWriter((Writer)closeable);
            printWriter.println("");
            printWriter.close();
            object = new Output();
            Date date = new Date();
            ((Output)object).out("Information about: " + string + "\nTime of gerneration: " + date.toString() + "\n", false);
        }
        catch (Exception exception) {
            Print.outln(exception.getMessage(), false);
        }
    }

    public Model start(String string) {
        block33: {
            this.initVRP();
            Model model = new Model(true);
            parser parser2 = null;
            RDF_Validator rDF_Validator = null;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.verbose) {
                Print.outln("Filename: " + string, false);
            }
            try {
                if (OutputFile != null) {
                    this.clean_file(string);
                }
                long l = System.currentTimeMillis();
                parser2 = new parser(string);
                this.setparseroptions(parser2);
                p_all = parser2;
                if (this.verbose) {
                    Print.outln("Parsing the file ...", false);
                }
                if (this.verbose) {
                    Print.outln("", false);
                }
                Object object = parser2.parse().value;
                long l2 = System.currentTimeMillis();
                if (this.only) {
                    Print.outln("Only......option enabled", true);
                    if (error_counter == 0) {
                        Print.outln("The file " + string + " is a valid RDF-File.", true);
                    } else {
                        Print.outln("The file " + string + " is not a valid RDF-File.", true);
                    }
                    if (this.timeStatistics) {
                        Print.outln("Time for parsing the input file : " + (l2 - l - parser2.getextParsingTime()) + " msec", true);
                    }
                    return null;
                }
                long l3 = 0L;
                long l4 = 0L;
                if (this.verbose) {
                    Print.outln("Start Validation", false);
                }
                if (object instanceof Model) {
                    Object object2;
                    Object object3;
                    model = (Model)object;
                    model.setResourceRoot(this.fetch_all);
                    model.castToMetaClass();
                    if (this.typeInfer) {
                        model.infer();
                    }
                    model.solve_links();
                    l3 = System.currentTimeMillis();
                    rDF_Validator = new RDF_Validator(model);
                    this.setvalidatoroptions(rDF_Validator);
                    rDF_Validator.validate();
                    l4 = System.currentTimeMillis();
                    if (warning_counter != 0) {
                        Print.outln(warning_counter + " warnings occured during processing the file " + string, true);
                    }
                    if (error_counter == 0) {
                        Print.outln("The file " + string + " is a valid RDF-File.", true);
                        bl = true;
                    } else {
                        Print.outln("The file " + string + " is not a valid RDF-File.", true);
                    }
                    error_counter = 0;
                    if (gui != null && model.getNamespaces().size() != 0) {
                        object3 = new ChooseOutNamespaceDialog(null, model.getNamespaces().keySet());
                        this.selectedNSURI = ((ChooseOutNamespaceDialog)object3).getSelectedNS();
                    }
                    if (this.selectedNSURI.size() != model.getNamespaces().size()) {
                        object3 = new HashSet();
                        object2 = this.selectedNSURI.iterator();
                        while (object2.hasNext()) {
                            String string2 = (String)object2.next();
                            Namespace namespace = (Namespace)model.getNamespaces().get(string2);
                            if (namespace != null) {
                                ((HashSet)object3).add(namespace);
                                continue;
                            }
                            Print.outln("\nThe namespace  " + string2 + " is not declared in the input file or you have not enabled the option external namespaces. Thus the namespace will not participate in the final output model\n", true);
                        }
                        model = model.getModelPart((HashSet)object3);
                        rDF_Validator = new RDF_Validator(model);
                        this.setvalidatoroptions(rDF_Validator);
                        rDF_Validator.create_class_dag();
                        rDF_Validator.getsubClassOfDAG().findRoots();
                        rDF_Validator.create_property_dag();
                        rDF_Validator.getsubPropertyOfDAG().findRoots();
                    }
                    if (this.graph) {
                        if (this.verbose) {
                            Print.outln("Writing the model to file " + OutputFile, false);
                        }
                        model.dump();
                    }
                    if (this.statements) {
                        if (this.verbose) {
                            Print.outln("Writing the triples of the model to file " + OutputFile, false);
                        }
                        model.printStatements();
                    }
                    if (this.timeStatistics) {
                        Print.outln("Time for parsing the input file : " + (l2 - l - parser2.getextParsingTime()) + " msec", true);
                        Print.outln("Time for parsing external namespaces & for inference on domain/range : " + (parser2.getextParsingTime() + rDF_Validator.getinheritTime()) + " msec\t", true);
                        Print.outln("Semantic validation time : " + (l4 - l3 - rDF_Validator.getinheritTime()) + " msec\t", true);
                    }
                    if (!bl) break block33;
                    if (this.modelStatistics[0] || this.modelStatistics[1] || this.modelStatistics[2] || this.modelStatistics[3]) {
                        if (!this.isAllConstraintSet()) {
                            Print.outln("Model statistics will be displayed only if all semantic constraints are selected", false);
                        } else {
                            this.getModelStatistics(model, rDF_Validator.getsubClassOfDAG(), rDF_Validator.getsubPropertyOfDAG());
                        }
                    }
                    if (this.svg) {
                        try {
                            object3 = new RDF_SemanticBroker(model, rDF_Validator);
                            object2 = new SVGGenerator((RDF_SemanticBroker)object3);
                            ((RDF_Visualization)object2).writeToFile(this.svgoutput);
                            Print.outln("SVG output file: " + this.svgoutput, true);
                        }
                        catch (Exception exception) {
                            Print.outln(exception.getMessage(), false);
                            exception.printStackTrace();
                        }
                    }
                    return model;
                }
                Print.outln("The file " + string + " is not a valid RDF-File.", true);
                if (this.modelStatistics[0] || this.modelStatistics[1] || this.modelStatistics[2] || this.modelStatistics[3]) {
                    Print.outln("Model statistics will be displayed only if the total descriptions are valid", false);
                }
                if (this.timeStatistics) {
                    Print.outln("Time for parsing the input file : " + (l2 - l - parser2.getextParsingTime()) + " msec", true);
                    Print.outln("Time for parsing external namespaces  :" + parser2.getextParsingTime() + " msec\t", true);
                }
            }
            catch (Exception exception) {
                Print.outln("Error during execution: " + exception.getMessage(), false);
            }
        }
        return null;
    }

    public void setparseroptions(parser parser2) {
        parser2.setonly(this.only);
        parser2.setdebug(this.debug);
        parser2.settriples(this.triples);
        parser2.setfetch_all(this.fetch_all);
        parser2.setsimple(this.simple);
        parser2.setverbose(this.verbose);
    }

    public void setmodeloptions(Model model) {
    }

    public void setvalidatoroptions(RDF_Validator rDF_Validator) {
        rDF_Validator.setverbose(this.verbose);
        rDF_Validator.setgraph(this.graph);
        rDF_Validator.setclassLoop(this.classLoop);
        rDF_Validator.setpropertyLoop(this.propertyLoop);
        rDF_Validator.setpropertyLoop(this.propertyLoop);
        rDF_Validator.setsubsetSubpropertyDomainRange(this.subsetSubpropertyDomainRange);
        rDF_Validator.settyping(this.typing);
        rDF_Validator.setsourceTargetTypes(this.sourceTargetTypes);
        rDF_Validator.setinheritance(this.inheritance);
    }

    private void set_options(String string) {
        RDF_Error rDF_Error = new RDF_Error();
        int n = string.length();
        while (n > 0) {
            String string2;
            if ((string2 = String.valueOf(string.charAt(--n))).equals("t")) {
                this.triples = true;
            }
            if (string2.equals("f")) {
                this.fetch = true;
            }
            if (string2.equals("a")) {
                this.fetch_all = true;
            }
            if (string2.equals("d")) {
                this.debug = true;
            }
            if (string2.equals("g")) {
                this.graph = true;
            }
            if (string2.equals("s")) {
                this.statements = true;
            }
            if (string2.equals("e")) {
                this.simple = true;
            }
            if (string2.equals("o")) {
                this.only = true;
            }
            if (string2.equals("v")) {
                this.verbose = true;
            }
            if (string2.equals("t") || string2.equals("f") || string2.equals("a") || string2.equals("d") || string2.equals("g") || string2.equals("e") || string2.equals("s") || string2.equals("o") || string2.equals("v")) continue;
            rDF_Error.emit_error(4, 7, "", "VRP.Main.set_options");
            System.exit(0);
        }
        int n2 = string.indexOf("a");
        int n3 = string.indexOf("f");
        if (n2 >= 0 && n3 >= 0) {
            rDF_Error.emit_error(4, 8, "The options 'a' and 'f' are not allowd together!", "VRP.Main.set_options");
            System.exit(0);
        }
    }

    private boolean isAllConstraintSet() {
        boolean bl = false;
        if (this.classLoop && this.propertyLoop && this.subsetSubpropertyDomainRange && this.typing && this.sourceTargetTypes) {
            bl = true;
        }
        return bl;
    }

    private void initVRP() {
        error_counter = 0;
        warning_counter = 0;
        this.setnoerrormsg(false);
    }

    void getModelStatistics(Model model, RDF_DAG rDF_DAG, RDF_DAG rDF_DAG2) {
        if (this.modelStatistics[0]) {
            model.printStatistics();
        }
        RDFModelStatistics rDFModelStatistics = new RDFModelStatistics(model);
        Output output = new Output();
        if (this.modelStatistics[1]) {
            output.outln("\nClass Hierarchies Statistics", true);
            output.outln("---------------------------------", true);
            rDFModelStatistics.printHierarchyStatistics(rDF_DAG, true);
        }
        if (this.modelStatistics[2]) {
            output.outln("\nProperty Hierarchies Statistics", true);
            output.outln("-----------------------------------", true);
            rDFModelStatistics.printHierarchyStatistics(rDF_DAG2, false);
        }
        if (this.modelStatistics[3]) {
            rDFModelStatistics.printInstanceDistribution();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("usage: java VRP.Main <filename> [<-options> [<filename>]]");
            stringBuffer.append("\n\n");
            stringBuffer.append(" valid options:");
            stringBuffer.append("\n\n");
            stringBuffer.append("\ta \tEnables the fetching of all explicit stated \n\t\tnamespaces. Should not be used together with the f option.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\td \tForces the lexical analyser to print the \n\t\ttoken name and token value he sends to \n\t\tthe parser.  If no file is specified for \n\t\tthe output it will be printed to stdout.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\te \tUsing a more simple lexical \n\t\tanalyser. Quicker and needs less memory.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\tf \tEnables the validator to connect to \n\t\tnamespaces.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\tg \tA textual representation of the model will be\n\t\tprinted. If no file is specified for the \n\t\toutput it will be printed to stdout.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\to \tThe parser will not send the triples to \n\t\tthe model. This means we have no \n\t\tvalidation against the RDF Schema and just \n\t\tmake a syntactic checking.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\ts \tThe triples of the model will be printed. \n\t\tIf no file is specified for the output \n\t\tit will be printed to stdout.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\tt \tThe triples of the parser will be printed. \n\t\tIf no file is specified for the output \n\t\tit will be printed to stdout.");
            stringBuffer.append("\n\n");
            stringBuffer.append("\tv \tCauses VRP to print a feedback of the activities \n\t\tto stdout.");
            stringBuffer.append("\n\n\n");
            stringBuffer.append("\t<filename> \tChanges the default output 'stdout' to <filename>.");
            Print.outln(stringBuffer.toString(), false);
            return;
        }
        Main main = new Main();
        String string = stringArray[0];
        if (stringArray.length > 3) {
            RDF_Error rDF_Error = new RDF_Error();
            rDF_Error.emit_error(4, 8, "", "VRP.Main");
            return;
        }
        if (stringArray.length > 1) {
            String string2 = stringArray[1];
            if (!string2.startsWith("-")) {
                RDF_Error rDF_Error = new RDF_Error();
                rDF_Error.emit_error(4, 9, "", "VRP.Main");
                return;
            }
            main.set_options(string2.substring(1));
        }
        if (stringArray.length > 2) {
            OutputFile = stringArray[2];
        }
        main.start(string);
    }

    static {
        error_counter = 0;
        noerrormsg = false;
        Print = new Output();
        warning_counter = 0;
    }
}

