/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.CharClassIntervall;
import JFlex.IntCharSet;
import JFlex.Intervall;
import JFlex.Out;
import java.util.Vector;

public class CharClasses {
    private static final boolean DEBUG = false;
    public static final char maxChar = '\uffff';
    private Vector classes;
    private char maxCharUsed;

    public CharClasses(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)n;
        this.classes = new Vector();
        this.classes.addElement(new IntCharSet(new Intervall('\u0000', '\uffff')));
    }

    public char getMaxCharCode() {
        return this.maxCharUsed;
    }

    public void setMaxCharCode(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)n;
    }

    public int getNumClasses() {
        return this.classes.size();
    }

    public void makeClass(IntCharSet intCharSet) {
        int n = this.classes.size();
        int n2 = 0;
        while (n2 < n) {
            IntCharSet intCharSet2 = (IntCharSet)this.classes.elementAt(n2);
            if (intCharSet2.equals(intCharSet)) {
                return;
            }
            IntCharSet intCharSet3 = intCharSet2.and(intCharSet);
            if (intCharSet3.containsElements()) {
                if (intCharSet2.equals(intCharSet3)) {
                    intCharSet.sub(intCharSet3);
                } else {
                    if (intCharSet.equals(intCharSet3)) {
                        intCharSet2.sub(intCharSet3);
                        this.classes.addElement(intCharSet3);
                        return;
                    }
                    intCharSet.sub(intCharSet3);
                    intCharSet2.sub(intCharSet3);
                    this.classes.addElement(intCharSet3);
                }
            }
            ++n2;
        }
    }

    public int getClassCode(char c) {
        IntCharSet intCharSet;
        int n = -1;
        while (!(intCharSet = (IntCharSet)this.classes.elementAt(++n)).contains(c)) {
        }
        return n;
    }

    public void dump() {
        Out.dump(this.toString());
    }

    public String toString(int n) {
        return this.classes.elementAt(n).toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CharClasses:");
        stringBuffer.append(Out.NL);
        int n = 0;
        while (n < this.classes.size()) {
            stringBuffer.append("class " + n + ":" + Out.NL + this.classes.elementAt(n) + Out.NL);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void makeClass(char c) {
        this.makeClass(new IntCharSet(c));
    }

    public void makeClass(String string) {
        int n = 0;
        while (n < string.length()) {
            this.makeClass(string.charAt(n));
            ++n;
        }
    }

    public void makeClass(Vector vector) {
        this.makeClass(new IntCharSet(vector));
    }

    public void makeClassNot(Vector vector) {
        this.makeClass(new IntCharSet(vector));
    }

    private int[] getClassCodes(IntCharSet intCharSet, boolean bl) {
        Object object;
        int n = this.classes.size();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            object = (IntCharSet)this.classes.elementAt(n3);
            if (bl) {
                if (!intCharSet.and((IntCharSet)object).containsElements()) {
                    nArray[n2++] = n3;
                }
            } else if (intCharSet.and((IntCharSet)object).containsElements()) {
                nArray[n2++] = n3;
            }
            ++n3;
        }
        object = new int[n2];
        System.arraycopy(nArray, 0, object, 0, n2);
        return object;
    }

    public int[] getClassCodes(Vector vector) {
        return this.getClassCodes(new IntCharSet(vector), false);
    }

    public int[] getNotClassCodes(Vector vector) {
        return this.getClassCodes(new IntCharSet(vector), true);
    }

    private void check() {
        int n = 0;
        while (n < this.classes.size()) {
            int n2 = n + 1;
            while (n2 < this.classes.size()) {
                IntCharSet intCharSet;
                IntCharSet intCharSet2 = (IntCharSet)this.classes.elementAt(n);
                if (intCharSet2.and(intCharSet = (IntCharSet)this.classes.elementAt(n2)).containsElements()) {
                    System.out.println("Error: non disjoint char classes " + n + " and " + n2);
                    System.out.println("class " + n + ": " + intCharSet2);
                    System.out.println("class " + n2 + ": " + intCharSet);
                }
                ++n2;
            }
            ++n;
        }
        char c = '\u0000';
        while (c < '\uffff') {
            this.getClassCode(c);
            if (c % 100 == 0) {
                System.out.print(".");
            }
            c = (char)(c + '\u0001');
        }
        this.getClassCode('\uffff');
    }

    public CharClassIntervall[] getIntervalls() {
        int n = this.classes.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += ((IntCharSet)this.classes.elementAt(n3)).numIntervalls();
            ++n3;
        }
        CharClassIntervall[] charClassIntervallArray = new CharClassIntervall[n2];
        n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = this.getClassCode((char)n4);
            IntCharSet intCharSet = (IntCharSet)this.classes.elementAt(n5);
            Intervall intervall = intCharSet.getNext();
            charClassIntervallArray[n3++] = new CharClassIntervall(intervall.start, intervall.end, n5);
            n4 = intervall.end + '\u0001';
        }
        return charClassIntervallArray;
    }
}

