/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BinaryBaseType;
import com.sun.msv.datatype.xsd.BinaryValueType;
import org.relaxng.datatype.ValidationContext;

public class Base64BinaryType
extends BinaryBaseType {
    public static final Base64BinaryType theInstance = new Base64BinaryType();
    private static final byte[] decodeMap = Base64BinaryType.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = Base64BinaryType.initEncodeMap();

    private Base64BinaryType() {
        super("base64Binary");
    }

    private static byte[] initDecodeMap() {
        byte[] byArray = new byte[256];
        int n = 0;
        while (n < 256) {
            byArray[n] = -1;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            byArray[n] = (byte)(n - 65);
            ++n;
        }
        n = 97;
        while (n <= 122) {
            byArray[n] = (byte)(n - 97 + 26);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            byArray[n] = (byte)(n - 48 + 52);
            ++n;
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    public Object _createValue(String string, ValidationContext validationContext) {
        byte[] byArray = Base64BinaryType.load(string);
        if (byArray == null) {
            return null;
        }
        return new BinaryValueType(byArray);
    }

    public static byte[] load(String string) {
        byte[] byArray = string.getBytes();
        int n = Base64BinaryType.calcLength(byArray);
        if (n == -1) {
            return null;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = byArray.length;
        byte[] byArray3 = new byte[4];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            byte by = decodeMap[byArray[n5]];
            if (by != -1) {
                byArray3[n4++] = by;
            }
            if (n4 == 4) {
                byArray2[n2++] = (byte)(byArray3[0] << 2 | byArray3[1] >> 4);
                if (byArray3[2] != 127) {
                    byArray2[n2++] = (byte)(byArray3[1] << 4 | byArray3[2] >> 2);
                }
                if (byArray3[3] != 127) {
                    byArray2[n2++] = (byte)(byArray3[2] << 6 | byArray3[3]);
                }
                n4 = 0;
            }
            ++n5;
        }
        if (n4 != 0) {
            throw new IllegalStateException();
        }
        return byArray2;
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        return Base64BinaryType.calcLength(string.getBytes()) != -1;
    }

    private static int calcLength(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (byArray[n4] == 61) break;
            if (decodeMap[byArray[n4]] != -1) {
                ++n2;
            }
            ++n4;
        }
        while (n4 < n) {
            if (byArray[n4] == 61) {
                ++n3;
            } else if (decodeMap[byArray[n4]] != -1) {
                return -1;
            }
            ++n4;
        }
        if (n3 > 2) {
            return -1;
        }
        if ((n2 + n3) % 4 != 0) {
            return -1;
        }
        return (n2 + n3) / 4 * 3 - n3;
    }

    private static char[] initEncodeMap() {
        char[] cArray = new char[64];
        int n = 0;
        while (n < 26) {
            cArray[n] = (char)(65 + n);
            ++n;
        }
        n = 26;
        while (n < 52) {
            cArray[n] = (char)(97 + (n - 26));
            ++n;
        }
        n = 52;
        while (n < 62) {
            cArray[n] = (char)(48 + (n - 52));
            ++n;
        }
        cArray[62] = 43;
        cArray[63] = 47;
        return cArray;
    }

    protected static char encode(int n) {
        return encodeMap[n & 0x3F];
    }

    public String serializeJavaObject(Object object, SerializationContext serializationContext) {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        return Base64BinaryType.save((byte[])object);
    }

    public static String save(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 4 / 3);
        int n = 0;
        while (n < byArray.length) {
            switch (byArray.length - n) {
                case 1: {
                    stringBuffer.append(Base64BinaryType.encode(byArray[n] >> 2));
                    stringBuffer.append(Base64BinaryType.encode((byArray[n] & 3) << 4));
                    stringBuffer.append("==");
                    break;
                }
                case 2: {
                    stringBuffer.append(Base64BinaryType.encode(byArray[n] >> 2));
                    stringBuffer.append(Base64BinaryType.encode((byArray[n] & 3) << 4 | byArray[n + 1] >> 4 & 0xF));
                    stringBuffer.append(Base64BinaryType.encode((byArray[n + 1] & 0xF) << 2));
                    stringBuffer.append("=");
                    break;
                }
                default: {
                    stringBuffer.append(Base64BinaryType.encode(byArray[n] >> 2));
                    stringBuffer.append(Base64BinaryType.encode((byArray[n] & 3) << 4 | byArray[n + 1] >> 4 & 0xF));
                    stringBuffer.append(Base64BinaryType.encode((byArray[n + 1] & 0xF) << 2 | byArray[n + 2] >> 6 & 3));
                    stringBuffer.append(Base64BinaryType.encode(byArray[n + 2] & 0x3F));
                }
            }
            n += 3;
        }
        return stringBuffer.toString();
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return this.serializeJavaObject(((BinaryValueType)object).rawData, serializationContext);
    }
}

