/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BuiltinAtomicType;
import com.sun.msv.datatype.xsd.Discrete;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.UnicodeUtil;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.apache.xerces.utils.regex.RegularExpression;
import org.relaxng.datatype.ValidationContext;

public class AnyURIType
extends BuiltinAtomicType
implements Discrete {
    public static final AnyURIType theInstance = new AnyURIType();
    private static final boolean[] isUric = AnyURIType.createUricMap();
    static final RegularExpression regexp = AnyURIType.createRegExp();
    static /* synthetic */ Class class$java$lang$String;

    private AnyURIType() {
        super("anyURI");
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        return regexp.matches(AnyURIType.escape(string));
    }

    private static void appendHex(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append((char)(n + 48));
        } else {
            stringBuffer.append((char)(n - 10 + 65));
        }
    }

    private static void appendByte(StringBuffer stringBuffer, int n) {
        stringBuffer.append('%');
        AnyURIType.appendHex(stringBuffer, n / 16);
        AnyURIType.appendHex(stringBuffer, n % 16);
    }

    private static void appendEscaped(StringBuffer stringBuffer, char c) {
        if (c < '\u007f') {
            AnyURIType.appendByte(stringBuffer, c);
            return;
        }
        if (c < '\u07ff') {
            AnyURIType.appendByte(stringBuffer, 192 + (c >> 6));
            AnyURIType.appendByte(stringBuffer, 128 + c % 64);
            return;
        }
        if (c < '\uffff') {
            AnyURIType.appendByte(stringBuffer, 224 + (c >> 12));
            AnyURIType.appendByte(stringBuffer, 128 + (c >> 6) % 64);
            AnyURIType.appendByte(stringBuffer, 128 + c % 64);
        }
    }

    private static void appendEscaped(StringBuffer stringBuffer, char c, char c2) {
        int n = ((c & 0x3FF) << 10) + (c2 & 0x3FF);
        AnyURIType.appendByte(stringBuffer, 240 + (n >> 18));
        AnyURIType.appendByte(stringBuffer, 128 + (n >> 12) % 64);
        AnyURIType.appendByte(stringBuffer, 128 + (n >> 6) % 64);
        AnyURIType.appendByte(stringBuffer, 128 + n % 64);
    }

    private static boolean[] createUricMap() {
        boolean[] blArray = new boolean[128];
        int n = 97;
        while (n <= 122) {
            blArray[n] = true;
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            blArray[n2] = true;
            ++n2;
        }
        int n3 = 48;
        while (n3 <= 57) {
            blArray[n3] = true;
            ++n3;
        }
        char[] cArray = new char[]{'-', '_', '.', '!', '~', '*', '\'', '(', ')', '#', '%', '[', ']'};
        int n4 = 0;
        while (n4 < cArray.length) {
            blArray[cArray[n4]] = true;
            ++n4;
        }
        char[] cArray2 = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
        int n5 = 0;
        while (n5 < cArray2.length) {
            blArray[cArray2[n5]] = true;
            ++n5;
        }
        return blArray;
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '\u0080' && isUric[c]) {
                stringBuffer.append(c);
            } else if ('\ud800' <= c && c < '\udc00') {
                AnyURIType.appendEscaped(stringBuffer, c, string.charAt(++n));
            } else {
                AnyURIType.appendEscaped(stringBuffer, c);
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    static RegularExpression createRegExp() {
        String string = "[a-zA-Z]";
        String string2 = "[0-9a-zA-Z]";
        String string3 = "[0-9a-fA-F]";
        String string4 = "%" + string3 + "{2}";
        String string5 = "[\\-_\\.!~\\*'\\(\\)]";
        String string6 = "(" + string2 + "|" + string5 + ")";
        String string7 = "[;/\\?:@&=\\+$,\\[\\]]";
        String string8 = "(" + string7 + "|" + string6 + "|" + string4 + ")";
        String string9 = string8 + "*";
        String string10 = string8 + "*";
        String string11 = "(" + string6 + "|" + string4 + "|[:@&=\\+$,])";
        String string12 = string11 + "*";
        String string13 = "(" + string12 + "(;" + string12 + ")*)";
        String string14 = "(" + string13 + "(/" + string13 + ")*)";
        String string15 = "[0-9]*";
        String string16 = "[0-9]{1,3}";
        String string17 = string16 + "\\." + string16 + "\\." + string16 + "\\." + string16;
        String string18 = string3 + "{1,4}";
        String string19 = string18 + "(:" + string18 + ")*";
        String string20 = "((" + string19 + "(::(" + string19 + ")?)?)|(::(" + string19 + ")?))";
        String string21 = "((" + string20 + "(:" + string17 + ")?)|(::" + string17 + "))";
        String string22 = "\\[" + string21 + "\\]";
        String string23 = string2 + "([0-9A-Za-z\\-]*" + string2 + ")?";
        String string24 = string + "([0-9A-Za-z\\-]*" + string2 + ")?";
        String string25 = "(" + string23 + "\\.)*" + string24 + "(\\.)?";
        String string26 = "((" + string25 + ")|(" + string17 + ")|(" + string22 + "))";
        String string27 = string26 + "(:" + string15 + ")?";
        String string28 = "(" + string6 + "|" + string4 + "|[;:&=\\+$,])*";
        String string29 = "((" + string28 + "@)?" + string27 + ")?";
        String string30 = "(" + string6 + "|" + string4 + "|[$,;:@&=\\+])+";
        String string31 = "((" + string29 + ")|(" + string30 + "))";
        String string32 = string + "[A-Za-z0-9\\+\\-\\.]*";
        String string33 = "(" + string6 + "|" + string4 + "|[;@&=\\+$,])+";
        String string34 = "/" + string14;
        String string35 = string33 + "(" + string34 + ")?";
        String string36 = "//" + string31 + "(" + string34 + ")?";
        String string37 = "(" + string6 + "|" + string4 + "|[;\\?:@&=\\+$,])";
        String string38 = string37 + "(" + string8 + ")*";
        String string39 = "((" + string36 + ")|(" + string34 + "))(\\?" + string10 + ")?";
        String string40 = "((" + string34 + ")|(" + string38 + "))?";
        String string41 = "((" + string36 + ")|(" + string34 + ")|(" + string35 + "))(\\?" + string10 + ")?";
        String string42 = string32 + ":((" + string39 + ")|(" + string38 + "))";
        String string43 = "(" + string42 + "|" + string41 + ")?(#" + string9 + ")?";
        return new RegularExpression(string43, "X");
    }

    public Object _createValue(String string, ValidationContext validationContext) {
        if (!regexp.matches(AnyURIType.escape(string))) {
            return null;
        }
        return string;
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException();
    }

    public final int isFacetApplicable(String string) {
        if (string.equals("length") || string.equals("minLength") || string.equals("maxLength") || string.equals("pattern") || string.equals("enumeration")) {
            return 0;
        }
        return -2;
    }

    public final int countLength(Object object) {
        return UnicodeUtil.countLength((String)object);
    }

    public Class getJavaObjectType() {
        return class$java$lang$String == null ? (class$java$lang$String = AnyURIType.class$("java.lang.String")) : class$java$lang$String;
    }

    public XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

